/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one;

import de.mossgrabers.controller.electra.one.ElectraOneConfiguration;
import de.mossgrabers.controller.electra.one.command.trigger.TouchCombinationCommand;
import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.DeviceMode;
import de.mossgrabers.controller.electra.one.mode.EqualizerMode;
import de.mossgrabers.controller.electra.one.mode.MixerMode;
import de.mossgrabers.controller.electra.one.mode.ProjectTrackMode;
import de.mossgrabers.controller.electra.one.mode.SendsMode;
import de.mossgrabers.controller.electra.one.mode.SessionMode;
import de.mossgrabers.controller.electra.one.mode.TransportMode;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.DummyMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.view.DummyView;
import de.mossgrabers.framework.view.Views;

public class ElectraOneControllerSetup
extends AbstractControllerSetup<ElectraOneControlSurface, ElectraOneConfiguration> {
    public ElectraOneControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new ElectraOneColorManager();
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new ElectraOneConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.enableDevice(DeviceID.EQ);
        ms.setWantsFocusedParameter(true);
        ms.setNumTracks(5);
        ms.setHasFlatTrackList(true);
        ms.setHasFullFlatTrackList(true);
        ms.setNumSends(6);
        ms.setNumMarkers(8);
        ms.setNumScenes(6);
        ms.setNumFilterColumnEntries(0);
        ms.setNumResults(0);
        ms.setNumDeviceLayers(0);
        ms.setNumDrumPadLayers(0);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput(0);
        IMidiInput input = midiAccess.createInput(0, null, new String[0]);
        for (int i = 0; i < 15; ++i) {
            input.createNoteInput("Channel " + (i + 1), String.format("?%X????", i));
        }
        IMidiOutput ctrlOutput = midiAccess.createOutput(1);
        IMidiInput ctrlInput = midiAccess.createInput(1, null, new String[0]);
        ElectraOneControlSurface surface = new ElectraOneControlSurface(this.host, this.colorManager, (ElectraOneConfiguration)this.configuration, output, input, ctrlInput, ctrlOutput);
        this.surfaces.add(surface);
        TouchCombinationCommand[] touchCombinationCommands = new TouchCombinationCommand[ElectraOneControlSurface.getTouchPatternSize()];
        for (int i = 0; i < touchCombinationCommands.length; ++i) {
            touchCombinationCommands[i] = new TouchCombinationCommand(i, this.model, surface);
        }
        surface.setTouchCombinationCommands(touchCombinationCommands);
        surface.getModeManager().setDefaultID(Modes.VOLUME);
    }

    @Override
    protected void createModes() {
        ElectraOneControlSurface surface = (ElectraOneControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.VOLUME, new MixerMode(surface, this.model));
        modeManager.register(Modes.SEND, new SendsMode(surface, this.model));
        modeManager.register(Modes.DEVICE_PARAMS, new DeviceMode(surface, this.model));
        modeManager.register(Modes.EQ_DEVICE_PARAMS, new EqualizerMode(surface, this.model));
        modeManager.register(Modes.TRANSPORT, new TransportMode(surface, this.model));
        modeManager.register(Modes.SESSION, new SessionMode(surface, this.model));
        modeManager.register(Modes.PROJECT, new ProjectTrackMode(surface, this.model));
        modeManager.register(Modes.DUMMY, new DummyMode(surface, this.model, ElectraOneControlSurface.KNOB_IDS));
    }

    @Override
    protected void createViews() {
        ElectraOneControlSurface surface = (ElectraOneControlSurface)this.getSurface();
        surface.getViewManager().register(Views.CONTROL, new DummyView("Control", surface, this.model));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ElectraOneControlSurface surface = (ElectraOneControlSurface)this.getSurface();
        ((ElectraOneConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        ((ElectraOneConfiguration)this.configuration).addSettingObserver(ElectraOneConfiguration.KNOB_TOUCH_COMBINATION_COMMANDS, ((ElectraOneControlSurface)this.getSurface())::updateTouchCombinationCommandsCache);
        ((ElectraOneConfiguration)this.configuration).addSettingObserver(ElectraOneConfiguration.LOG_TO_CONSOLE, surface::setLoggingEnabled);
    }

    @Override
    protected void registerTriggerCommands() {
        ElectraOneControlSurface surface = (ElectraOneControlSurface)this.getSurface();
        for (int row = 0; row < 6; ++row) {
            int rowLabel = row + 1;
            for (int col = 0; col < 6; ++col) {
                ButtonID buttonID = ElectraOneControlSurface.getButtonID(row, col);
                int colLabel = col + 1;
                int cc = 70 + 10 * row + col;
                ButtonRowModeCommand command = new ButtonRowModeCommand(row, col, this.model, surface);
                this.addButton(surface, buttonID, "Row " + rowLabel + ": " + colLabel, command, 15, cc, () -> this.getButtonColor(surface, buttonID), new String[0]);
            }
        }
    }

    @Override
    protected void registerContinuousCommands() {
        for (int row = 0; row < 6; ++row) {
            int rowLabel = row + 1;
            for (int col = 0; col < 6; ++col) {
                ContinuousID ctrlID = ElectraOneControlSurface.getContinuousID(row, col);
                int colLabel = col + 1;
                int cc = 10 + 10 * row + col;
                IHwRelativeKnob ctrl = this.addRelativeKnob(ctrlID, "Ctrl " + rowLabel + "-" + colLabel, null, BindType.CC, 15, cc);
                if (col >= 6) continue;
                ctrl.setIndexInGroup(row * 6 + col);
            }
        }
    }

    @Override
    protected void layoutControls() {
        ElectraOneControlSurface surface = (ElectraOneControlSurface)this.getSurface();
        double width = 12.0;
        double height = 10.0;
        double padding = 4.0;
        double offsetY = 98.0;
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 6; ++col) {
                double x = 4.0 + (double)col * 16.0;
                double y = 4.0 + (double)row * 14.0;
                ContinuousID ctrlID = ElectraOneControlSurface.getContinuousID(row, col);
                surface.getContinuous(ctrlID).setBounds(x, y, 12.0, 10.0);
                ButtonID buttonID = ElectraOneControlSurface.getButtonID(row, col);
                surface.getButton(buttonID).setBounds(x, 98.0 + y, 12.0, 10.0);
            }
        }
    }

    @Override
    public void startup() {
        ElectraOneControlSurface surface = (ElectraOneControlSurface)this.getSurface();
        surface.getViewManager().setActive(Views.CONTROL);
        surface.requestDeviceInfo();
    }
}

