/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.track.CrossfadeParameterProvider;
import java.util.HashMap;
import java.util.Map;

public class CrossfadeMode
extends AbstractTrackMode {
    private static final Map<String, String> CROSSFADE_TEXT = new HashMap<String, String>(3);

    public CrossfadeMode(PushControlSurface surface, IModel model) {
        super("Crossfade", surface, model);
        this.setParameterProvider(new CrossfadeParameterProvider(model));
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            if (!t.doesExist()) continue;
            display.setCell(0, i, "Crossfdr");
            IParameter crossfadeParameter = t.getCrossfadeParameter();
            display.setCell(1, i, CROSSFADE_TEXT.get(crossfadeParameter.getDisplayedValue()));
            display.setCell(2, i, crossfadeParameter.getValue(), Format.FORMAT_PAN);
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        this.updateChannelDisplay(display, 3, false, false);
    }

    static {
        CROSSFADE_TEXT.put("A", "A");
        CROSSFADE_TEXT.put("B", "       B");
        CROSSFADE_TEXT.put("AB", "   <> ");
    }
}

