/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.nativefiledialogs.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import de.mossgrabers.nativefiledialogs.AbstractNativeFileDialogs;
import de.mossgrabers.nativefiledialogs.FileFilter;
import de.mossgrabers.nativefiledialogs.windows.Comdlg32;
import de.mossgrabers.nativefiledialogs.windows.Shell32;
import java.io.File;
import java.io.IOException;

public class NativeWindowsFileDialogs
extends AbstractNativeFileDialogs {
    private static final int MAX_PATH_LENGTH = 4000;
    private final String parentWindowClassName;

    public NativeWindowsFileDialogs(File currentDirectory, String parentWindowClassName) {
        super(currentDirectory);
        this.parentWindowClassName = parentWindowClassName;
    }

    @Override
    public File selectFile(String title, FileFilter ... filters) throws IOException {
        return this.showDialog(true, title, filters);
    }

    @Override
    public File selectNewFile(String title, FileFilter ... filters) throws IOException {
        return this.showDialog(false, title, filters);
    }

    @Override
    public File selectFolder(String title) {
        Shell32.BrowseInfoCallback proc = (wnd, msg, param, lpData) -> {
            if (msg == 1 && this.currentDirectory != null) {
                File dir = this.currentDirectory.isDirectory() ? this.currentDirectory : this.currentDirectory.getParentFile();
                String path = dir.getAbsolutePath();
                Memory m = new Memory((long)Native.WCHAR_SIZE * (long)(path.length() + 1));
                m.setWideString(0L, path);
                User32.INSTANCE.PostMessage(new WinDef.HWND(wnd), 1127, new WinDef.WPARAM(1L), new WinDef.LPARAM(Pointer.nativeValue((Pointer)m)));
            }
            return 0;
        };
        Ole32.INSTANCE.OleInitialize(null);
        Shell32.BrowseInfo params = new Shell32.BrowseInfo();
        params.hwndOwner = this.getParentWindow();
        params.ulFlags = 81;
        if (title != null) {
            params.lpszTitle = title;
        }
        params.lpfn = proc;
        Pointer pidl = Shell32.SHBrowseForFolder(params);
        if (pidl == null) {
            return null;
        }
        Memory path = new Memory(4000L);
        Shell32.SHGetPathFromIDListW(pidl, (Pointer)path);
        File file = new File(path.getWideString(0L));
        Ole32.INSTANCE.CoTaskMemFree(pidl);
        this.currentDirectory = file;
        return file;
    }

    private File showDialog(boolean open, String title, FileFilter[] filters) throws IOException {
        Comdlg32.OpenFileName params = this.configureParameters(title, filters);
        if (open ? Comdlg32.GetOpenFileNameW(params) : Comdlg32.GetSaveFileNameW(params)) {
            this.currentDirectory = params.getSelectedFile();
            return this.currentDirectory;
        }
        int errCode = Comdlg32.CommDlgExtendedError();
        if (errCode != 0) {
            throw new IOException("GetOpenFileName failed with error " + errCode);
        }
        return null;
    }

    private Comdlg32.OpenFileName configureParameters(String title, FileFilter[] filters) {
        Comdlg32.OpenFileName params = new Comdlg32.OpenFileName();
        params.Flags = 0x88000C;
        params.hwndOwner = this.getParentWindow();
        if (title != null) {
            params.lpstrTitle = new WString(title);
        }
        int bufferLength = 260;
        int bufferSize = 1041;
        params.lpstrFile = new Memory(1041L);
        params.lpstrFile.clear(1041L);
        params.nMaxFile = 260;
        if (this.currentDirectory != null) {
            params.lpstrInitialDir = this.currentDirectory.getAbsolutePath();
            if (this.currentDirectory.isFile()) {
                params.lpstrFile.setWideString(0L, this.currentDirectory.getAbsolutePath());
            }
        }
        if (filters != null && filters.length > 0) {
            params.lpstrFilter = new WString(NativeWindowsFileDialogs.buildFilterString(filters));
            params.nFilterIndex = 1;
        }
        return params;
    }

    private static String buildFilterString(FileFilter[] filters) {
        StringBuilder filterStr = new StringBuilder();
        for (FileFilter spec : filters) {
            StringBuilder exts = new StringBuilder();
            String[] extensions = spec.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                if (i > 0) {
                    exts.append(';');
                }
                exts.append("*.").append(extensions[i]);
            }
            filterStr.append(spec.getLabel()).append(" (").append((CharSequence)exts).append(")\u0000");
            filterStr.append((CharSequence)exts).append('\u0000');
        }
        return filterStr.append('\u0000').toString();
    }

    private Pointer getParentWindow() {
        if (this.parentWindowClassName == null) {
            return null;
        }
        WinDef.HWND windowHandle = User32.INSTANCE.FindWindow(this.parentWindowClassName, null);
        return windowHandle == null ? null : windowHandle.getPointer();
    }
}

