/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.text.Position;

public final class Functions {
    private static final String ICON_PATH = "/images/ui/";
    private static final String ICON_TYPE = ".png";
    private static final int ICON_SCALE = 20;
    private static ResourceBundle messages;
    private static Dimension openSaveDlgDim;
    private static Map<Integer, Map<String, ImageIcon>> icons;

    public static void init(ResourceBundle messages) {
        Functions.init(messages, null);
    }

    public static void init(ResourceBundle messages, Dimension openSaveDlgDim) {
        Functions.messages = messages;
        Functions.setOpenSaveDlgDim(openSaveDlgDim);
    }

    public static ImageIcon getIcon(String name) {
        return Functions.getIcon(name, 20);
    }

    public static ImageIcon getIcon(String name, int size) {
        Map map = icons.computeIfAbsent(size, iconSize -> new HashMap());
        return map.computeIfAbsent(name, iconName -> {
            String resource = ICON_PATH + iconName + ICON_TYPE;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image loadImage = toolkit.getImage(Functions.class.getResource(resource));
            Image scaledImage = loadImage.getScaledInstance(size, size, 4);
            return new ImageIcon(scaledImage);
        });
    }

    public static ImageIcon iconFor(String iconName) {
        if (iconName == null) {
            return null;
        }
        URL resource = ClassLoader.getSystemResource(iconName);
        if (resource == null) {
            resource = Thread.currentThread().getContextClassLoader().getResource(iconName);
        }
        return resource != null ? new ImageIcon(resource) : null;
    }

    public static String getMessage(String messageID, String ... replaceStrings) {
        String message;
        String string = message = messages == null ? "" : messages.getString(messageID);
        if (replaceStrings != null) {
            message = Functions.replacePercentNWithStrings(message, replaceStrings);
        }
        return message;
    }

    public static String getMessage(String messageID, Throwable ex) {
        String msg = ex.getLocalizedMessage();
        return Functions.getMessage(messageID, msg == null ? ex.getClass().getName() : msg);
    }

    public static String getText(String text) {
        if (Functions.noEmptyString(text) == null) {
            return "";
        }
        return text.charAt(0) == '@' ? Functions.getMessage(text.substring(1), new String[0]) : text;
    }

    public static void message(Throwable ex) {
        String msg = ex.getLocalizedMessage();
        Functions.message(msg == null ? ex.getClass().getName() : msg, new String[]{null});
    }

    public static void message(String message, Throwable ex) {
        String msg = ex.getLocalizedMessage();
        Functions.message(message, msg == null ? ex.getClass().getName() : msg);
    }

    public static void message(String message, String ... replaceStrings) {
        String t = Functions.getText(message);
        JOptionPane.showMessageDialog(Functions.getFocusedFrame(), replaceStrings == null ? t : Functions.replacePercentNWithStrings(t, replaceStrings));
    }

    public static boolean yesOrNo(String message) {
        return Functions.yesOrNo(message, new String[]{null});
    }

    public static boolean yesOrNo(Frame frame, String message) {
        return Functions.yesOrNo(frame, message, new String[]{null});
    }

    public static boolean yesOrNo(String message, String ... replaceStrings) {
        return Functions.yesOrNo(Functions.getFocusedFrame(), message, replaceStrings);
    }

    public static boolean yesOrNo(Frame frame, String message, String ... replaceStrings) {
        String t = Functions.getText(message);
        return JOptionPane.showConfirmDialog(frame, replaceStrings == null ? t : Functions.replacePercentNWithStrings(t, replaceStrings), frame.getTitle(), 0) == 0;
    }

    public static boolean chooseFromTwo(String message, String title, String ... options) {
        return Functions.chooseFromTwo(Functions.getFocusedFrame(), message, title, options);
    }

    public static boolean chooseFromTwo(Component parent, String message, String title, String ... options) {
        return Functions.choose(parent, message, title, options) == 0;
    }

    public static int choose(String message, String title, String ... options) {
        return Functions.choose(Functions.getFocusedFrame(), message, title, options);
    }

    public static int choose(Component parent, String message, String title, String ... options) {
        for (int i = 0; i < options.length; ++i) {
            options[i] = Functions.getText(options[i]);
        }
        return JOptionPane.showOptionDialog(parent, Functions.getText(message), Functions.getText(title), options.length == 2 ? 0 : 1, 3, null, options, null);
    }

    public static String noEmptyString(String value) {
        return value != null && value.length() == 0 ? null : value;
    }

    public static String noNullString(String value) {
        return value == null ? "" : value;
    }

    public static boolean compare(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static String replacePercentNWithStrings(String message, String[] replaceStrings) {
        String m = message;
        for (int i = 0; i < replaceStrings.length; ++i) {
            int pos = m.indexOf("%" + (i + 1));
            if (pos == -1 || replaceStrings[i] == null) continue;
            m = m.substring(0, pos) + replaceStrings[i] + m.substring(pos + 2);
        }
        return m;
    }

    public static void asHighAs(JComponent idol, JComponent fan) {
        Dimension idolSize = idol.getPreferredSize();
        Dimension fanSize = fan.getPreferredSize();
        fanSize.height = idolSize.height;
        fan.setMaximumSize(fanSize);
        fan.setPreferredSize(fanSize);
    }

    public static void asWidthAs(JComponent idol, JComponent fan) {
        Dimension idolSize = idol.getPreferredSize();
        Dimension fanSize = fan.getPreferredSize();
        fanSize.width = idolSize.width;
        fan.setMaximumSize(fanSize);
        fan.setPreferredSize(fanSize);
    }

    public static void fixScrollPaneTo(JComponent component, int width, int height) {
        Container comp = component.getParent().getParent();
        if (comp instanceof JComponent) {
            JComponent c = (JComponent)comp;
            Dimension dim = new Dimension(width, height);
            c.setMinimumSize(dim);
            c.setPreferredSize(dim);
        }
    }

    public static void fixScrollPaneTo(JComponent component, int width) {
        Container comp = component.getParent().getParent();
        if (comp instanceof JComponent) {
            JComponent c = (JComponent)comp;
            Dimension dim = c.getPreferredSize();
            dim.width = width;
            c.setMinimumSize(dim);
            c.setPreferredSize(dim);
        }
    }

    public static void enableComponent(Component c, boolean enable) {
        c.setEnabled(enable);
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component element : container.getComponents()) {
                Functions.enableComponent(element, enable);
            }
        }
    }

    public static void showPopupMenu(JPopupMenu menu, MouseEvent e) {
        Functions.showPopupMenu(menu, e.getComponent(), e.getX(), e.getY());
    }

    public static void showPopupMenu(JPopupMenu menu, Component component, int x, int y) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point pos = component.getLocationOnScreen();
        Dimension menuSize = menu.getPreferredSize();
        int larger = pos.x + x + menuSize.width - screenSize.width;
        menu.show(component, larger > 0 ? x - larger : x, pos.y + y + menuSize.height > screenSize.height ? y - menuSize.height : y);
    }

    public static void setBusy(boolean busy) {
        Frame frame = Functions.getFocusedFrame();
        if (frame instanceof JFrame) {
            JFrame jf = (JFrame)frame;
            jf.getGlassPane().setVisible(busy);
        }
    }

    public static Frame getFocusedFrame() {
        Frame[] frames;
        for (Frame element : frames = Frame.getFrames()) {
            if (element.getFocusOwner() == null) continue;
            return element;
        }
        return frames.length > 0 ? frames[0] : null;
    }

    public static <T> int getNextMatch(JList<T> listbox, String subtext, int startIndex, Position.Bias bias) {
        ListModel<T> model = listbox.getModel();
        int max = model.getSize();
        if (subtext == null || startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        String subTextUpper = subtext.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        while ((index = (index + increment + max) % max) != startIndex) {
            String string;
            T element = model.getElementAt(index);
            if (element == null || (string = element.toString()) == null || !string.toUpperCase().contains(subTextUpper)) continue;
            return index;
        }
        return -1;
    }

    static Dimension getOpenSaveDlgDim() {
        return openSaveDlgDim;
    }

    static void setOpenSaveDlgDim(Dimension openSaveDlgDim) {
        Functions.openSaveDlgDim = openSaveDlgDim;
    }

    private Functions() {
    }

    static {
        icons = new HashMap<Integer, Map<String, ImageIcon>>();
    }

    static class Chooser
    extends JFileChooser {
        private static final long serialVersionUID = 3977304317382505779L;
        String existanceMsg;
        boolean open;

        public Chooser(boolean open, String currentPath, String existanceMsg, boolean allowFolders) {
            this.open = open;
            if (currentPath != null) {
                File cp = new File(currentPath);
                if (cp.isDirectory()) {
                    this.setCurrentDirectory(cp);
                } else {
                    this.setSelectedFile(cp);
                }
            }
            this.existanceMsg = existanceMsg;
            if (this.existanceMsg != null && this.existanceMsg.length() > 0 && this.existanceMsg.charAt(0) == '@') {
                this.existanceMsg = Functions.getMessage(this.existanceMsg.substring(1), new String[0]);
            }
            this.setFileSelectionMode(allowFolders ? 2 : 0);
            this.setFileHidingEnabled(true);
            Dimension size = Functions.getOpenSaveDlgDim();
            if (size != null) {
                this.setPreferredSize(size);
            }
        }

        @Override
        public void approveSelection() {
            Functions.setOpenSaveDlgDim(this.getSize());
            File file = this.getSelectedFile();
            if (!this.open && file.exists() && !Functions.yesOrNo(this.existanceMsg, file.getPath())) {
                return;
            }
            super.approveSelection();
        }
    }
}

