/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;
import de.mossgrabers.reaper.framework.daw.data.SceneImpl;

public class SlotImpl
extends ItemImpl
implements ISlot {
    private final ITrack track;
    private boolean hasContent;
    private boolean isMuted;
    private ColorEx color = new ColorEx(0.2, 0.2, 0.2);
    private final ISceneBank sceneBank;

    public SlotImpl(DataSetupEx dataSetup, ITrack track, int index, ISceneBank sceneBank) {
        super(dataSetup, index);
        this.track = track;
        this.sceneBank = sceneBank;
    }

    @Override
    public boolean hasContent() {
        return this.hasContent;
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    public void setMuted(boolean isMuted) {
        this.isMuted = isMuted;
    }

    @Override
    public boolean isRecordingQueued() {
        return false;
    }

    @Override
    public boolean isRecording() {
        if (!this.doesExist()) {
            return false;
        }
        IScene scene = (IScene)this.sceneBank.getItem(this.index);
        if (scene.doesExist() && scene instanceof SceneImpl) {
            SceneImpl sceneImpl = (SceneImpl)scene;
            ITransport transport = this.dataSetup.getTransport();
            if (transport.isRecording() && this.track.isRecArm()) {
                double playPosition = transport.getPosition();
                return playPosition >= sceneImpl.getBeginPosition() && playPosition <= sceneImpl.getEndPosition();
            }
        }
        return false;
    }

    @Override
    public boolean isPlayingQueued() {
        return false;
    }

    @Override
    public boolean isPlaying() {
        if (!this.doesExist() || !this.hasContent()) {
            return false;
        }
        IScene scene = (IScene)this.sceneBank.getItem(this.index);
        if (scene.doesExist() && scene instanceof SceneImpl) {
            SceneImpl sceneImpl = (SceneImpl)scene;
            ITransport transport = this.dataSetup.getTransport();
            if (transport.isPlaying()) {
                double playPosition = transport.getPosition();
                return playPosition >= sceneImpl.getBeginPosition() && playPosition <= sceneImpl.getEndPosition();
            }
        }
        return false;
    }

    @Override
    public boolean isStopQueued() {
        return false;
    }

    @Override
    public ColorEx getColor() {
        return this.color;
    }

    @Override
    public void setColor(ColorEx color) {
        this.color = color;
    }

    @Override
    public void select() {
        if (this.getIndex() >= 0) {
            this.sendTrackClipOSC("select");
        }
    }

    @Override
    public void launch(boolean isPressed, boolean isAlternative) {
        if (isPressed && this.getIndex() >= 0) {
            this.sendTrackClipOSC("launch");
        }
    }

    @Override
    public void startRecording() {
        if (this.getIndex() >= 0) {
            this.sendTrackClipOSC("record");
        }
    }

    @Override
    public void remove() {
        if (this.getIndex() >= 0) {
            this.sendTrackClipOSC("remove");
        }
    }

    @Override
    public void duplicate() {
        if (this.getIndex() >= 0) {
            this.sendTrackClipOSC("duplicate");
        }
    }

    @Override
    public void paste(ISlot slot) {
        slot.duplicate();
    }

    @Override
    public void insertFile(String path) {
        if (this.getIndex() >= 0) {
            this.sendTrackClipOSC("insertFile", path);
        }
    }

    private void sendTrackClipOSC(String command) {
        this.sendOSC(this.track.getIndex() + "/clip/" + this.getPosition() + "/" + command);
    }

    private void sendTrackClipOSC(String command, String value) {
        this.sendOSC(this.track.getIndex() + "/clip/" + this.getPosition() + "/" + command, value);
    }

    @Override
    protected Processor getProcessor() {
        return Processor.TRACK;
    }
}

