/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.utils;

import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.observer.INoteObserver;
import de.mossgrabers.framework.scale.Scales;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class KeyManager
implements INoteObserver {
    private final int[] pressedKeys = new int[128];
    private final IModel model;
    private final Scales scales;
    private final IPadGrid padGrid;
    private int[] noteMap = Scales.getEmptyMatrix();

    public KeyManager(IModel model, Scales scales, IPadGrid padGrid) {
        this.model = model;
        this.scales = scales;
        this.padGrid = padGrid;
        Arrays.fill(this.pressedKeys, 0);
    }

    public void clearPressedKeys() {
        Arrays.fill(this.pressedKeys, 0);
    }

    public boolean isKeyPressed(int key) {
        return this.pressedKeys[key] > 0;
    }

    public void setKeyPressed(int key, int velocity) {
        this.pressedKeys[key] = velocity;
    }

    public void setAllKeysPressed(int key, int velocity) {
        for (int i = 0; i < 128; ++i) {
            if (this.noteMap[i] != key) continue;
            this.setKeyPressed(i, velocity);
        }
    }

    @Override
    public void call(int trackIndex, int note, int velocity) {
        Optional sel = this.model.getCurrentTrackBank().getSelectedItem();
        if (sel.isPresent() && ((ITrack)sel.get()).getIndex() == trackIndex) {
            this.setAllKeysPressed(note, velocity);
        }
    }

    public List<Integer> getPressedKeys() {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (int i = 0; i < 128; ++i) {
            if (this.pressedKeys[i] == 0) continue;
            keys.add(i);
        }
        return keys;
    }

    public boolean hasPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            if (this.pressedKeys[i] == 0) continue;
            return true;
        }
        return false;
    }

    public int getMidiNoteFromGrid(int note) {
        return this.padGrid == null ? -1 : this.map(this.padGrid.translateToGrid(note));
    }

    public List<Integer> getMidiNotesFromPressedKeys() {
        List<Integer> pressed = this.getPressedKeys();
        int size = pressed.size();
        ArrayList<Integer> notes = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            notes.add(this.map(pressed.get(i)));
        }
        return notes;
    }

    public int map(int note) {
        return note < 0 ? -1 : this.noteMap[note];
    }

    public String getColor(int pad) {
        return this.scales.getColor(this.noteMap, pad);
    }

    public void setNoteMatrix(int[] matrix) {
        this.noteMap = matrix;
    }

    public Scales getScales() {
        return this.scales;
    }
}

