/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.continuous;

import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;

public class MasterVolumeCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractContinuousCommand<S, C> {
    public MasterVolumeCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        if (this.surface.isSelectPressed()) {
            ITransport transport = this.model.getTransport();
            transport.changeMetronomeVolume(value);
            this.surface.getDisplay().notify("Metronome Volume: " + transport.getMetronomeVolumeStr());
        } else {
            this.model.getMasterTrack().changeVolume(value);
        }
    }
}

