/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.mode;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.utils.StringUtils;

public class SLVolumeMode
extends TrackVolumeMode<SLControlSurface, SLConfiguration> {
    public SLVolumeMode(SLControlSurface surface, IModel model) {
        super(surface, model, true, ContinuousID.createSequentialList(ContinuousID.FADER1, 8));
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((SLControlSurface)this.surface).getTextDisplay().clearRow(2).clearRow(3);
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            String n = t.getName();
            d.setCell(2, i, StringUtils.shortenAndFixASCII((String)(t.isSelected() ? ">" + n : n), 8));
            d.setCell(3, i, t.getVolumeStr(8));
        }
        d.done(2).done(3);
    }

    @Override
    public void onActivate() {
        if (!this.isActive) {
            super.onActivate();
        }
    }

    @Override
    public void onDeactivate() {
    }
}

