/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class SLConfiguration
extends AbstractConfiguration {
    public static final Integer TOUCHPAD_MODE = 50;
    public static final Integer DRUMPADS_AS_MODE_SELECTION = 51;
    public static final String TOUCHPAD_MODE_CROSSFADER = "Crossfader";
    public static final String TOUCHPAD_MODE_PARAMETER = "Remote Parameter 1&2";
    private static final String[] TOUCHPAD_OPTIONS = new String[]{"Crossfader", "Remote Parameter 1&2"};
    private String touchpadMode;
    private boolean drumpadsAsModeSelection = false;
    private final boolean isMkII;

    public SLConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, boolean isMkII) {
        super(host, valueChanger, arpeggiatorModes);
        this.isMkII = isMkII;
    }

    public boolean isMkII() {
        return this.isMkII;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        IEnumSetting touchpadModeSetting = globalSettings.getEnumSetting("Mode", "Touchpad", TOUCHPAD_OPTIONS, TOUCHPAD_OPTIONS[1]);
        touchpadModeSetting.addValueObserver(value -> {
            this.touchpadMode = value;
            this.notifyObservers(TOUCHPAD_MODE);
        });
        this.isSettingActive.add(TOUCHPAD_MODE);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        IEnumSetting drumpadsAsModeSelectionSetting = globalSettings.getEnumSetting("Use drum pads for mode selection", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        drumpadsAsModeSelectionSetting.addValueObserver(value -> {
            this.drumpadsAsModeSelection = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(DRUMPADS_AS_MODE_SELECTION);
        });
        this.isSettingActive.add(DRUMPADS_AS_MODE_SELECTION);
    }

    public String getTouchpadMode() {
        return this.touchpadMode;
    }

    public boolean isDrumpadsAsModeSelection() {
        return this.drumpadsAsModeSelection;
    }
}

