/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.command.trigger;

import de.mossgrabers.controller.ni.maschine.core.MaschineColorManager;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.framework.command.trigger.clip.StartSceneCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class MaschineJamStartSceneCommand
extends StartSceneCommand<MaschineJamControlSurface, MaschineJamConfiguration> {
    private static final Views[] SEQUENCER_VIEWS = new Views[]{Views.SEQUENCER, Views.POLY_SEQUENCER, Views.RAINDROPS, Views.DRUM, Views.DRUM4, Views.DRUM8, null, null};
    private static final Views[] PLAY_VIEWS = new Views[]{Views.PLAY, Views.CHORDS, Views.PIANO, Views.DRUM64, null, null, null, null};

    public MaschineJamStartSceneCommand(IModel model, MaschineJamControlSurface surface, int index) {
        super(model, surface, index);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((MaschineJamControlSurface)this.surface).getViewManager();
        if (((MaschineJamControlSurface)this.surface).isSelectPressed()) {
            IScene scene = this.getScene();
            if (scene.doesExist()) {
                scene.select();
            }
            return;
        }
        if (((MaschineJamControlSurface)this.surface).isPressed(ButtonID.SEQUENCER)) {
            ((MaschineJamControlSurface)this.surface).setTriggerConsumed(ButtonID.SEQUENCER);
            if (SEQUENCER_VIEWS[this.index] != null) {
                this.activatePreferredView(SEQUENCER_VIEWS[this.index]);
                this.mvHelper.delayDisplay(() -> ((IView)viewManager.getActive()).getName());
            }
            return;
        }
        if (((MaschineJamControlSurface)this.surface).isPressed(ButtonID.NOTE)) {
            ((MaschineJamControlSurface)this.surface).setTriggerConsumed(ButtonID.NOTE);
            if (PLAY_VIEWS[this.index] != null) {
                this.activatePreferredView(PLAY_VIEWS[this.index]);
                this.mvHelper.delayDisplay(() -> ((IView)viewManager.getActive()).getName());
            }
            return;
        }
        super.executeNormal(event);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.LONG) {
            return;
        }
        IScene scene = this.getScene();
        if (scene.doesExist()) {
            scene.launch(event == ButtonEvent.DOWN, true);
        }
        if (event == ButtonEvent.DOWN) {
            ((MaschineJamControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
        }
    }

    public int getButtonColor() {
        MaschineColorManager colorManager = (MaschineColorManager)this.model.getColorManager();
        if (((MaschineJamControlSurface)this.surface).isPressed(ButtonID.SEQUENCER)) {
            if (SEQUENCER_VIEWS[this.index] == null) {
                return colorManager.getColorIndex("BUTTON_STATE_OFF");
            }
            return ((MaschineJamControlSurface)this.surface).getViewManager().isActive(new Views[]{SEQUENCER_VIEWS[this.index]}) ? 30 : 77;
        }
        if (((MaschineJamControlSurface)this.surface).isPressed(ButtonID.NOTE)) {
            if (PLAY_VIEWS[this.index] == null) {
                return colorManager.getColorIndex("BUTTON_STATE_OFF");
            }
            return ((MaschineJamControlSurface)this.surface).getViewManager().isActive(new Views[]{PLAY_VIEWS[this.index]}) ? 42 : 77;
        }
        IScene scene = this.getScene();
        if (scene.doesExist()) {
            return colorManager.dimOrHighlightColor(scene.getColor(), scene.isSelected());
        }
        return 0;
    }
}

