/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.controller.arturia.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.featuregroup.AbstractView;

public class SessionView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private final TrackEditing extensions;

    public SessionView(BeatstepControlSurface surface, IModel model) {
        super("Session", surface, model);
        this.extensions = new TrackEditing(surface, model);
    }

    @Override
    public void onKnob(int index, int value) {
        if (index < 12) {
            this.extensions.onTrackKnob(index, value);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
        int index = note - 36;
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (velocity <= 0) break;
                sceneBank.selectPreviousPage();
                break;
            }
            case 7: {
                if (velocity <= 0) break;
                sceneBank.selectNextPage();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                ((IScene)sceneBank.getItem(index - 8)).launch(velocity > 0, false);
                break;
            }
        }
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        for (i = 0; i < 6; ++i) {
            padGrid.light(36 + i, 0);
        }
        for (i = 6; i < 8; ++i) {
            padGrid.light(36 + i, 16);
        }
        for (i = 8; i < 16; ++i) {
            padGrid.light(36 + i, 16);
        }
    }
}

