/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.command.trigger;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class SelectTrackSendOrClipLengthCommand
extends AbstractTriggerCommand<APCControlSurface, APCConfiguration> {
    private final int index;

    public SelectTrackSendOrClipLengthCommand(int index, IModel model, APCControlSurface surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ModeManager modeManager = ((APCControlSurface)this.surface).getModeManager();
        if (((APCControlSurface)this.surface).isPressed(ButtonID.SEND1)) {
            Modes sendModeId = Modes.get(Modes.SEND1, this.index);
            ((APCControlSurface)this.surface).setTriggerConsumed(ButtonID.SEND1);
            if (((APCControlSurface)this.surface).isMkII()) {
                ((ModeMultiSelectCommand)((APCControlSurface)this.surface).getButton(ButtonID.SEND1).getCommand()).activateMode(sendModeId);
            } else {
                modeManager.setActive(sendModeId);
            }
            String modeName = "Send " + (this.index + 1) + ": ";
            ITrackBank trackBank = this.model.getTrackBank();
            Optional selectedTrack = trackBank.getSelectedItem();
            if (selectedTrack.isEmpty()) {
                ITrack item = (ITrack)trackBank.getItem(0);
                selectedTrack = item.doesExist() ? Optional.of(item) : Optional.empty();
            }
            modeName = selectedTrack.isEmpty() ? modeName + "-" : modeName + ((ISend)((ITrack)selectedTrack.get()).getSendBank().getItem(this.index)).getName();
            ((APCControlSurface)this.surface).getDisplay().notify(modeName);
            return;
        }
        if (((APCControlSurface)this.surface).isMkII() && ((APCControlSurface)this.surface).isPressed(ButtonID.SEND2)) {
            ((APCControlSurface)this.surface).setTriggerConsumed(ButtonID.SEND2);
            ((IMode)modeManager.get(Modes.USER)).selectItemPage(this.index);
            return;
        }
        ((ITrack)this.model.getCurrentTrackBank().getItem(this.index)).selectOrExpandGroup();
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ((APCControlSurface)this.surface).getDisplay().notify(AbstractConfiguration.getNewClipLengthValue(this.index));
        ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setNewClipLength(this.index);
    }
}

