/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.utilities.autocolor;

import de.mossgrabers.controller.utilities.autocolor.AutoColorConfiguration;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AutoColor {
    private final EnumMap<DAWColor, List<Pattern>> colorRegex = new EnumMap(DAWColor.class);
    private final AutoColorConfiguration configuration;
    private ITrackBank trackBank;
    private final IHost host;

    protected AutoColor(AutoColorConfiguration configuration, IHost host) {
        this.configuration = configuration;
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRegExChange(DAWColor color, String filter) {
        if (!this.configuration.isEnableAutoColor()) {
            return;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (filter != null && !filter.trim().isEmpty()) {
            for (String part : filter.split(",")) {
                patterns.add(Pattern.compile(".*" + Pattern.quote(part.trim()) + ".*"));
            }
        }
        String[] stringArray = this.colorRegex;
        synchronized (this.colorRegex) {
            this.colorRegex.put(color, patterns);
            if (!patterns.isEmpty()) {
                this.updateTracks(color, patterns);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public void matchTrackName(int channelIndex, String trackName) {
        if (this.configuration.isEnableAutoColor() && !trackName.trim().isEmpty()) {
            this.matchColorsToTrack((ITrack)this.trackBank.getItem(channelIndex), trackName);
        }
    }

    private void updateTracks(DAWColor color, List<Pattern> patterns) {
        for (int i = 0; i < this.trackBank.getPageSize(); ++i) {
            ITrack track = (ITrack)this.trackBank.getItem(i);
            this.matchColorToTrack(track, track.getName(), color, patterns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchColorsToTrack(ITrack track, String trackName) {
        EnumMap<DAWColor, List<Pattern>> enumMap = this.colorRegex;
        synchronized (enumMap) {
            for (Map.Entry<DAWColor, List<Pattern>> e : this.colorRegex.entrySet()) {
                this.matchColorToTrack(track, trackName, e.getKey(), e.getValue());
            }
        }
    }

    private void matchColorToTrack(ITrack track, String trackName, DAWColor color, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            ColorEx newColor;
            if (!pattern.matcher(trackName).matches()) continue;
            ColorEx currentColor = track.getColor();
            if (currentColor.equals(newColor = color.getColor())) break;
            this.host.scheduleTask(() -> {
                if (trackName.equals(track.getName())) {
                    track.setColor(newColor);
                }
            }, 500L);
            break;
        }
    }

    public void setTrackBank(ITrackBank trackBank) {
        this.trackBank = trackBank;
    }
}

