/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.sequencer.AbstractPolySequencerView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class PolySequencerView
extends AbstractPolySequencerView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    private NotePosition noteEditPosition;

    public PolySequencerView(LaunchpadControlSurface surface, IModel model, boolean useTrackColor) {
        super(surface, model, useTrackColor);
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, int channel, int step) {
        boolean isUpPressed = ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.UP);
        if (isUpPressed || ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.DOWN)) {
            ((LaunchpadControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.UP : ButtonID.DOWN);
            NotePosition notePosition = new NotePosition(channel, step, 0);
            for (int row = 0; row < 128; ++row) {
                notePosition.setNote(row);
                if (clip.getStep(notePosition).getState() == StepState.OFF) continue;
                this.handleSequencerAreaRepeatOperator(clip, notePosition, 127, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, channel, step);
    }

    @Override
    protected void handleSequencerArea(int x, int y, int velocity) {
        if (velocity != 0) {
            this.noteEditPosition = null;
            return;
        }
        if (this.noteEditPosition != null) {
            INoteClip clip = this.getClip();
            this.clearEditNotes();
            for (int row = 0; row < 128; ++row) {
                this.noteEditPosition.setNote(row);
                if (clip.getStep(this.noteEditPosition).getState() != StepState.START) continue;
                this.editNote(clip, this.noteEditPosition, true);
            }
            return;
        }
        super.handleSequencerArea(x, y, velocity);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - 36;
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        if (y < this.numRows - this.numSequencerRows) {
            return;
        }
        int step = this.numColumns * (this.numRows - 1 - y) + x;
        this.noteEditPosition = new NotePosition(this.configuration.getMidiEditChannel(), step, 0);
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        INoteClip clip = ((AbstractSequencerView)AbstractSequencerView.class.cast(viewManager.getActive())).getClip();
        int seqOctave = this.scales.getOctave();
        scrollStates.setCanScrollLeft(clip.canScrollStepsBackwards());
        scrollStates.setCanScrollRight(clip.canScrollStepsForwards());
        scrollStates.setCanScrollUp(seqOctave < 4);
        scrollStates.setCanScrollDown(seqOctave > -4);
    }
}

