/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.NoteEditor;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.utils.ButtonEvent;

public class NoteEditView
extends AbstractFaderView
implements INoteEditorMode {
    private static final int[] COLUMN_COLORS = new int[]{46, 42, 58, 46, 60, 30, 14, 4};
    private final boolean[] columnPan;
    private final NoteParameter[] parameters;
    private final NoteParameter muteParameter;
    private final NoteEditor noteEditor = new NoteEditor();

    public NoteEditView(LaunchpadControlSurface surface, IModel model) {
        super("Note Edit", surface, model);
        IValueChanger valueChanger = model.getValueChanger();
        this.muteParameter = new NoteParameter(NoteAttribute.MUTE, null, model, this.noteEditor, valueChanger);
        this.parameters = new NoteParameter[]{new NoteParameter(NoteAttribute.VELOCITY, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY_SPREAD, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.CHANCE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.GAIN, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PANNING, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TRANSPOSE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TIMBRE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PRESSURE, null, model, this.noteEditor, valueChanger)};
        IHost host = model.getHost();
        this.columnPan = new boolean[]{false, false, false, host.supports(NoteAttribute.GAIN), host.supports(NoteAttribute.PANNING), host.supports(NoteAttribute.TRANSPOSE), host.supports(NoteAttribute.TIMBRE), false};
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.noteEditor.clearNotes();
    }

    @Override
    public void setupFader(int index) {
        ((LaunchpadControlSurface)this.surface).setupFader(index, COLUMN_COLORS[index], this.columnPan[index]);
        this.onValueKnob(index, this.getFaderValue(index));
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.parameters[index].setValueImmediatly(value);
    }

    @Override
    protected int getFaderValue(int index) {
        return this.parameters[index].getValue();
    }

    @Override
    public void drawGrid() {
        for (int i = 0; i < 8; ++i) {
            ((LaunchpadControlSurface)this.surface).setFaderValue(i, this.parameters[i].getValue());
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event == ButtonEvent.DOWN && buttonID == ButtonID.SCENE1) {
            this.muteParameter.setNormalizedValue(this.muteParameter.getValue() > 0 ? 0.0 : 1.0);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE1) {
            return this.muteParameter.getValue() > 0 ? 5 : 1;
        }
        return 0;
    }

    @Override
    public INoteEditor getNoteEditor() {
        return this.noteEditor;
    }
}

