/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.mode.track;

import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1Display;
import de.mossgrabers.controller.ni.kontrol.mki.mode.AbstractKontrol1Mode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Locale;
import java.util.Optional;

public class VolumeMode
extends AbstractKontrol1Mode<ITrack> {
    public VolumeMode(Kontrol1ControlSurface surface, IModel model) {
        super("Volume", surface, model, model.getCurrentTrackBank());
        model.addTrackBankObserver(x$0 -> this.switchBanks(x$0));
        this.setParameterProvider(new VolumeParameterProvider(model));
    }

    @Override
    public void updateDisplay() {
        Kontrol1Display d = (Kontrol1Display)((Kontrol1ControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 0, this.model.isEffectTrackBankActive() ? "VOL-FX" : "VOLUME").setCell(1, 0, this.formatPageRange("%d - %d"));
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selTrack = tb.getSelectedItem();
        int selIndex = selTrack.isEmpty() ? -1 : ((ITrack)selTrack.get()).getIndex();
        for (int i = 0; i < 8; ++i) {
            boolean isSel = i == selIndex;
            ITrack t = (ITrack)tb.getItem(i);
            String n = StringUtils.shortenAndFixASCII(t.getName(), isSel ? 7 : 8).toUpperCase(Locale.US);
            d.setCell(0, 1 + i, (String)(isSel ? ">" + n : n)).setCell(1, 1 + i, VolumeMode.getSecondLineText(t));
            d.setBar(1 + i, ((Kontrol1ControlSurface)this.surface).getContinuous(ContinuousID.get(ContinuousID.KNOB1, i)).isTouched() && t.doesExist(), t.getVolume());
        }
        d.allDone();
    }
}

