/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.gamepad;

import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerManager;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.ISignalSetting;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.MidiConstants;
import de.mossgrabers.framework.scale.Scales;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class GamepadConfiguration
extends AbstractConfiguration {
    public static final int FUNCTION_OFF = 0;
    public static final int FUNCTION_NOTE_0 = 1;
    public static final int FUNCTION_NOTE_127 = 128;
    public static final int FUNCTION_CC_0 = 129;
    public static final int FUNCTION_CC_127 = 256;
    public static final int FUNCTION_PITCHBEND = 257;
    public static final int FUNCTION_NOTE_REPEAT_ENABLE = 258;
    public static final int FUNCTION_NOTE_REPEAT_PERIOD = 259;
    public static final int FUNCTION_NOTE_REPEAT_LENGTH = 260;
    public static final int FUNCTION_TRACK_PREVIOUS = 261;
    public static final int FUNCTION_TRACK_NEXT = 262;
    public static final int FUNCTION_CLIP_PREVIOUS = 263;
    public static final int FUNCTION_CLIP_NEXT = 264;
    public static final int FUNCTION_NEW_CLIP = 265;
    public static final int FUNCTION_PLAY_CLIP = 266;
    public static final int FUNCTION_TRANSPORT_PLAY = 267;
    public static final int FUNCTION_TRANSPORT_METRONOME = 268;
    public static final int FUNCTION_RANGE_127 = 0;
    public static final int FUNCTION_RANGE_CENTER_64 = 1;
    public static final int FUNCTION_RANGE_CENTER_64_FLIP = 2;
    public static final Integer SELECTED_GAMEPAD = 50;
    private static final String NOT_AVAILABLE = "<Not available>";
    private static final String CATEGORY_GAMEPAD = "Gamepad";
    private static final List<String> FUNCTIONS = new ArrayList<String>();
    private static final List<String> FUNCTION_RANGES = new ArrayList<String>();
    private static final Map<ControllerButton, String> BUTTON_NAMES = new EnumMap<ControllerButton, String>(ControllerButton.class);
    private static final Map<ControllerAxis, String> AXIS_NAMES = new EnumMap<ControllerAxis, String>(ControllerAxis.class);
    private static final Map<ControllerButton, Integer> BUTTON_DEFAULTS = new EnumMap<ControllerButton, Integer>(ControllerButton.class);
    private static final Map<ControllerAxis, Integer> AXIS_DEFAULTS = new EnumMap<ControllerAxis, Integer>(ControllerAxis.class);
    private final ControllerManager gamepadManager;
    private final List<String> gamepadNames = new ArrayList<String>();
    private final IEnumSetting[] buttonSettings = new IEnumSetting[ControllerButton.values().length];
    private final IEnumSetting[] axisSettings = new IEnumSetting[ControllerAxis.values().length];
    private final IEnumSetting[] axisRangeSettings = new IEnumSetting[ControllerAxis.values().length];
    private int selectedGamepad = -1;
    private final Map<ControllerButton, Integer> buttonFunctions = new EnumMap<ControllerButton, Integer>(ControllerButton.class);
    private final Map<ControllerAxis, Integer> axisFunctions = new EnumMap<ControllerAxis, Integer>(ControllerAxis.class);
    private final Map<ControllerAxis, Integer> axisRanges = new EnumMap<ControllerAxis, Integer>(ControllerAxis.class);

    public GamepadConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, ControllerManager gamepadManager) {
        super(host, valueChanger, arpeggiatorModes);
        this.gamepadManager = gamepadManager;
        this.fillGamepads();
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        IEnumSetting gamepadSetting = globalSettings.getEnumSetting(CATEGORY_GAMEPAD, CATEGORY_GAMEPAD, this.gamepadNames, this.gamepadNames.get(0));
        gamepadSetting.setVisible(this.gamepadManager.getNumControllers() > 0);
        ISignalSetting actionSetting = globalSettings.getSignalSetting("Update the list of connected gamepads", CATEGORY_GAMEPAD, "Refresh");
        actionSetting.addSignalObserver(Void2 -> this.host.restart());
        ControllerButton[] buttons = ControllerButton.values();
        String buttonCategory = "Gamepad - Buttons";
        for (int i = 0; i < buttons.length; ++i) {
            int pos = i;
            String initialValue = FUNCTIONS.get(BUTTON_DEFAULTS.get(buttons[i]));
            this.buttonSettings[i] = globalSettings.getEnumSetting(BUTTON_NAMES.get(buttons[i]), "Gamepad - Buttons", FUNCTIONS, initialValue);
            this.buttonSettings[i].addValueObserver(value -> this.buttonFunctions.put(buttons[pos], FUNCTIONS.indexOf(value)));
        }
        ControllerAxis[] axes = ControllerAxis.values();
        String axisCategory = "Gamepad - Axis";
        for (int i = 0; i < axes.length; ++i) {
            int pos = i;
            String initialValue = FUNCTIONS.get(AXIS_DEFAULTS.get(axes[i]));
            String label = AXIS_NAMES.get(axes[i]);
            this.axisSettings[i] = globalSettings.getEnumSetting(label, "Gamepad - Axis", FUNCTIONS, initialValue);
            this.axisSettings[i].addValueObserver(value -> this.axisFunctions.put(axes[pos], FUNCTIONS.indexOf(value)));
            this.axisRangeSettings[i] = globalSettings.getEnumSetting(label + " Range (CC only)", "Gamepad - Axis", FUNCTION_RANGES, FUNCTION_RANGES.get(0));
            this.axisRangeSettings[i].addValueObserver(value -> this.axisRanges.put(axes[pos], FUNCTION_RANGES.indexOf(value)));
        }
        gamepadSetting.addValueObserver(value -> {
            this.selectedGamepad = NOT_AVAILABLE.equals(value) ? -1 : this.gamepadNames.indexOf(value) - 1;
            this.updateFunctionSettings();
            this.notifyObservers(SELECTED_GAMEPAD);
        });
        this.activateNoteRepeatSetting(documentSettings);
    }

    private void updateFunctionSettings() {
        try {
            ControllerIndex gamepad = this.selectedGamepad < 0 ? null : this.gamepadManager.getControllerIndex(this.selectedGamepad);
            ControllerButton[] buttons = ControllerButton.values();
            for (int i = 0; i < buttons.length; ++i) {
                this.buttonSettings[i].setEnabled(gamepad != null && gamepad.isButtonAvailable(buttons[i]));
            }
            ControllerAxis[] axes = ControllerAxis.values();
            for (int i = 0; i < axes.length; ++i) {
                this.axisSettings[i].setEnabled(gamepad != null && gamepad.isAxisAvailable(axes[i]));
            }
        }
        catch (ControllerUnpluggedException | RuntimeException ex) {
            this.host.error("Could not access controller.", ex);
        }
    }

    public int getSelectedGamepad() {
        return this.selectedGamepad;
    }

    public int getFunction(ControllerButton button) {
        Integer f = this.buttonFunctions.get(button);
        return f == null ? -1 : f;
    }

    public int getFunction(ControllerAxis axis) {
        Integer f = this.axisFunctions.get(axis);
        return f == null ? -1 : f;
    }

    public int getFunctionRange(ControllerAxis axis) {
        Integer r = this.axisRanges.get(axis);
        return r == null ? -1 : r;
    }

    private void fillGamepads() {
        int numGamepads = this.gamepadManager.getNumControllers();
        this.gamepadNames.add("None");
        if (numGamepads == 0) {
            this.gamepadNames.add("<No controllers>");
            return;
        }
        for (int i = 0; i < numGamepads; ++i) {
            try {
                this.gamepadNames.add(this.gamepadManager.getControllerIndex(i).getName());
                continue;
            }
            catch (ControllerUnpluggedException ex) {
                this.gamepadNames.add(NOT_AVAILABLE);
            }
        }
    }

    static {
        FUNCTIONS.add("Off");
        for (int i = 0; i < 128; ++i) {
            FUNCTIONS.add("Note " + Scales.formatNoteAndOctave(i, -3));
        }
        String[] ccNames = MidiConstants.getCCNames();
        for (int i = 0; i < 128; ++i) {
            FUNCTIONS.add("CC " + ccNames[i]);
        }
        FUNCTIONS.add("Pitchbend");
        FUNCTIONS.add("Note Repeat: On/Off");
        FUNCTIONS.add("Note Repeat: Period (only for axis)");
        FUNCTIONS.add("Note Repeat: Length (only for axis)");
        FUNCTIONS.add("Track: Select Previous");
        FUNCTIONS.add("Track: Select Next");
        FUNCTIONS.add("Clip: Select Previous");
        FUNCTIONS.add("Clip: Select Next");
        FUNCTIONS.add("Clip: New (only for buttons)");
        FUNCTIONS.add("Clip: Play (only for buttons)");
        FUNCTIONS.add("Transport: Play/Stop (only for buttons)");
        FUNCTIONS.add("Transport: Metronome (only for buttons)");
        FUNCTION_RANGES.add("127 - 0  :  0 - 127");
        FUNCTION_RANGES.add("0   - 64 : 64 - 127");
        FUNCTION_RANGES.add("127 - 64 : 64 - 0");
        BUTTON_NAMES.put(ControllerButton.A, "A");
        BUTTON_NAMES.put(ControllerButton.B, "B");
        BUTTON_NAMES.put(ControllerButton.X, "X");
        BUTTON_NAMES.put(ControllerButton.Y, "Y");
        BUTTON_NAMES.put(ControllerButton.BACK, "Back");
        BUTTON_NAMES.put(ControllerButton.GUIDE, "Guide");
        BUTTON_NAMES.put(ControllerButton.START, "Start");
        BUTTON_NAMES.put(ControllerButton.LEFTSTICK, "Left Stick");
        BUTTON_NAMES.put(ControllerButton.RIGHTSTICK, "Right Stick");
        BUTTON_NAMES.put(ControllerButton.LEFTBUMPER, "Left Bumper");
        BUTTON_NAMES.put(ControllerButton.RIGHTBUMPER, "Right Bumper");
        BUTTON_NAMES.put(ControllerButton.DPAD_UP, "Cursor Up");
        BUTTON_NAMES.put(ControllerButton.DPAD_DOWN, "Cursor Down");
        BUTTON_NAMES.put(ControllerButton.DPAD_LEFT, "Cursor Left");
        BUTTON_NAMES.put(ControllerButton.DPAD_RIGHT, "Cursor Right");
        BUTTON_NAMES.put(ControllerButton.BUTTON_MISC1, "Xbox Series X share button, PS5 microphone button, Nintendo Switch Pro capture button");
        BUTTON_NAMES.put(ControllerButton.BUTTON_PADDLE1, "Xbox Elite paddle P1");
        BUTTON_NAMES.put(ControllerButton.BUTTON_PADDLE2, "Xbox Elite paddle P3");
        BUTTON_NAMES.put(ControllerButton.BUTTON_PADDLE3, "Xbox Elite paddle P2");
        BUTTON_NAMES.put(ControllerButton.BUTTON_PADDLE4, "Xbox Elite paddle P4");
        BUTTON_NAMES.put(ControllerButton.BUTTON_TOUCHPAD, "PS4/PS5 touchpad button");
        BUTTON_DEFAULTS.put(ControllerButton.A, 258);
        BUTTON_DEFAULTS.put(ControllerButton.B, 265);
        BUTTON_DEFAULTS.put(ControllerButton.X, 0);
        BUTTON_DEFAULTS.put(ControllerButton.Y, 0);
        BUTTON_DEFAULTS.put(ControllerButton.BACK, 266);
        BUTTON_DEFAULTS.put(ControllerButton.GUIDE, 268);
        BUTTON_DEFAULTS.put(ControllerButton.START, 267);
        BUTTON_DEFAULTS.put(ControllerButton.LEFTSTICK, 0);
        BUTTON_DEFAULTS.put(ControllerButton.RIGHTSTICK, 0);
        BUTTON_DEFAULTS.put(ControllerButton.LEFTBUMPER, 38);
        BUTTON_DEFAULTS.put(ControllerButton.RIGHTBUMPER, 39);
        BUTTON_DEFAULTS.put(ControllerButton.DPAD_UP, 261);
        BUTTON_DEFAULTS.put(ControllerButton.DPAD_DOWN, 262);
        BUTTON_DEFAULTS.put(ControllerButton.DPAD_LEFT, 263);
        BUTTON_DEFAULTS.put(ControllerButton.DPAD_RIGHT, 264);
        BUTTON_DEFAULTS.put(ControllerButton.BUTTON_MISC1, 0);
        BUTTON_DEFAULTS.put(ControllerButton.BUTTON_PADDLE1, 0);
        BUTTON_DEFAULTS.put(ControllerButton.BUTTON_PADDLE2, 0);
        BUTTON_DEFAULTS.put(ControllerButton.BUTTON_PADDLE3, 0);
        BUTTON_DEFAULTS.put(ControllerButton.BUTTON_PADDLE4, 0);
        BUTTON_DEFAULTS.put(ControllerButton.BUTTON_TOUCHPAD, 0);
        AXIS_NAMES.put(ControllerAxis.LEFTX, "Left X");
        AXIS_NAMES.put(ControllerAxis.LEFTY, "Left Y");
        AXIS_NAMES.put(ControllerAxis.RIGHTX, "Right X");
        AXIS_NAMES.put(ControllerAxis.RIGHTY, "Right Y");
        AXIS_NAMES.put(ControllerAxis.TRIGGERLEFT, "Trigger Left");
        AXIS_NAMES.put(ControllerAxis.TRIGGERRIGHT, "Trigger Right");
        AXIS_DEFAULTS.put(ControllerAxis.LEFTX, 257);
        AXIS_DEFAULTS.put(ControllerAxis.LEFTY, 130);
        AXIS_DEFAULTS.put(ControllerAxis.RIGHTX, 200);
        AXIS_DEFAULTS.put(ControllerAxis.RIGHTY, 203);
        AXIS_DEFAULTS.put(ControllerAxis.TRIGGERLEFT, 37);
        AXIS_DEFAULTS.put(ControllerAxis.TRIGGERRIGHT, 40);
    }
}

