/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class ShiftView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private static final Views[] VIEWS = new Views[]{Views.TRACK, Views.DEVICE, Views.PLAY, Views.DRUM, Views.SEQUENCER, Views.SESSION};
    private final PlayCommand<BeatstepControlSurface, BeatstepConfiguration> playCommand;

    public ShiftView(BeatstepControlSurface surface, IModel model) {
        super("Shift", surface, model);
        this.playCommand = new PlayCommand(model, surface);
    }

    @Override
    public void drawGrid() {
        ITransport t = this.model.getTransport();
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        padGrid.light(36, t.isPlaying() ? 17 : 16);
        padGrid.light(37, t.isRecording() ? 17 : 1);
        padGrid.light(38, t.isLoop() ? 17 : 0);
        padGrid.light(39, t.isMetronomeOn() ? 17 : 0);
        padGrid.light(40, 0);
        padGrid.light(41, 1);
        padGrid.light(42, 1);
        padGrid.light(43, 1);
        padGrid.light(44, 1);
        padGrid.light(45, 1);
        padGrid.light(46, 17);
        padGrid.light(47, 17);
        padGrid.light(48, 17);
        padGrid.light(49, 16);
        padGrid.light(50, 0);
        padGrid.light(51, this.model.getCursorDevice().isWindowOpen() ? 17 : 16);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        switch (note - 36) {
            case 0: {
                this.playCommand.executeNormal(ButtonEvent.UP);
                break;
            }
            case 1: {
                this.model.getTransport().startRecording();
                break;
            }
            case 2: {
                this.model.getTransport().toggleLoop();
                break;
            }
            case 3: {
                this.model.getTransport().toggleMetronome();
                break;
            }
            case 4: {
                this.model.getTransport().tapTempo();
                break;
            }
            case 5: {
                this.model.getBrowser().insertBeforeCursorDevice();
                break;
            }
            case 6: {
                this.model.getBrowser().insertAfterCursorDevice();
                break;
            }
            case 7: {
                this.model.getBrowser().replace(cursorDevice);
                break;
            }
            case 15: {
                cursorDevice.toggleWindowOpen();
                break;
            }
            default: {
                int viewIndex = note - 44;
                if (viewIndex < 0 || viewIndex >= 6) {
                    return;
                }
                ViewManager viewManager = ((BeatstepControlSurface)this.surface).getViewManager();
                Views viewId = VIEWS[viewIndex];
                viewManager.setPreviousID(viewId);
                IView view = (IView)viewManager.get(viewId);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(view.getName());
            }
        }
    }

    @Override
    public void onKnob(int index, int value) {
    }
}

