/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.view.sequencer.AbstractNoteSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<PushControlSurface, PushConfiguration> {
    public SequencerView(PushControlSurface surface, IModel model) {
        super("Sequencer", surface, model, true);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - 36;
        ((PushControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int y = index / 8;
        if (y >= this.numSequencerRows) {
            return;
        }
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), index % 8, this.keyManager.map(y));
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity) {
        boolean isSelectPressed = ((PushControlSurface)this.surface).isSelectPressed();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, !isSelectPressed);
            }
            return true;
        }
        if (isSelectPressed) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            this.editNote(clip, notePosition, true);
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity);
    }
}

