/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IBounds;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.StringUtils;

public class MidiClipComponent
implements IComponent {
    private final INoteClip clip;
    private final int quartersPerMeasure;
    private final NotePosition activePosition;

    public MidiClipComponent(INoteClip clip, int quartersPerMeasure, NotePosition activePosition) {
        this.clip = clip;
        this.quartersPerMeasure = quartersPerMeasure;
        this.activePosition = activePosition;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        double playEnd;
        double playStart;
        IGraphicsConfiguration configuration = info.getConfiguration();
        ColorEx gridBackground = configuration.getColorBackgroundLighter();
        ColorEx measureTextColor = ColorEx.WHITE;
        ColorEx dividersColor = configuration.getColorBackgroundDarker();
        ColorEx clipColor = this.clip.getColor();
        ColorEx noteColor = this.clip.getColor();
        ColorEx noteActiveColor = ColorEx.WHITE;
        ColorEx noteMutedColor = ColorEx.DARK_GRAY;
        ColorEx noteGridLoopColor = configuration.getColorBackground();
        ColorEx noteBorderColor = ColorEx.BLACK;
        IGraphicsContext gc = info.getContext();
        IBounds bounds = info.getBounds();
        double left = bounds.left();
        double width = bounds.width();
        double height = bounds.height();
        int top = 14;
        double noteAreaHeight = height - 14.0;
        gc.fillRectangle(left, 14.0, width, noteAreaHeight, gridBackground);
        int numSteps = this.clip.getNumSteps();
        double stepLength = this.clip.getStepLength();
        double pageLength = (double)numSteps * stepLength;
        int editPage = this.clip.getEditPage();
        double startPos = (double)editPage * pageLength;
        double endPos = (double)(editPage + 1) * pageLength;
        int len = 13;
        if (this.clip.isLoopEnabled()) {
            double loopStart = this.clip.getLoopStart();
            double loopLength = this.clip.getLoopLength();
            if (loopStart < endPos && loopStart + loopLength > startPos) {
                double start = Math.max(0.0, loopStart - startPos);
                double end = Math.min(endPos, loopStart + loopLength) - startPos;
                double x = width * start / pageLength;
                double w = width * end / pageLength - x;
                gc.fillRectangle(x + 1.0, 0.0, w, 13.0, clipColor);
                gc.fillRectangle(x + 1.0, 14.0, w, noteAreaHeight, noteGridLoopColor);
            }
        }
        if ((playStart = this.clip.getPlayStart()) >= startPos && playStart <= endPos) {
            double start = playStart - startPos;
            double x = width * start / pageLength;
            gc.fillTriangle(x + 1.0, 0.0, x + 1.0 + 13.0, 6.5, x + 1.0, 13.0, clipColor);
            gc.strokeTriangle(x + 1.0, 0.0, x + 1.0 + 13.0, 6.5, x + 1.0, 13.0, ColorEx.evenDarker(clipColor));
        }
        if ((playEnd = this.clip.getPlayEnd()) >= startPos && playEnd <= endPos) {
            double end = playEnd - startPos;
            double x = width * end / pageLength;
            gc.fillTriangle(x + 1.0, 0.0, x + 1.0, 13.0, x + 1.0 - 14.0, 6.5, clipColor);
            gc.strokeTriangle(x + 1.0, 0.0, x + 1.0, 13.0, x + 1.0 - 14.0, 6.5, ColorEx.evenDarker(clipColor));
        }
        double stepWidth = width / (double)numSteps;
        for (int step = 0; step <= numSteps; ++step) {
            double x = left + (double)step * stepWidth;
            gc.fillRectangle(x, 14.0, 1.0, noteAreaHeight, dividersColor);
            if (step % 4 != 0) continue;
            double time = startPos + (double)step * stepLength;
            String measureText = StringUtils.formatMeasures(this.quartersPerMeasure, time, 1, false);
            gc.drawTextInHeight(measureText, x, 0.0, 13.0, measureTextColor, 14.0);
        }
        int lowerRowWithData = this.clip.getLowestRowWithData();
        if (lowerRowWithData == -1) {
            return;
        }
        int upperRowWithData = this.clip.getHighestRowWithData();
        int range = Math.max(4, 1 + upperRowWithData - lowerRowWithData);
        double stepHeight = noteAreaHeight / (double)range;
        double fontSize = gc.calculateFontSize("G#5", stepHeight, stepWidth, 12.0);
        NotePosition notePosition = new NotePosition();
        for (int row = 0; row < range; ++row) {
            notePosition.setNote(lowerRowWithData + row);
            gc.fillRectangle(left, 14.0 + (double)(range - row - 1) * stepHeight, width, 1.0, dividersColor);
            for (int step = 0; step < numSteps; ++step) {
                notePosition.setStep(step);
                for (int channel = 0; channel < 16; ++channel) {
                    ColorEx stepNoteBackgroundColor;
                    boolean isStart;
                    notePosition.setChannel(channel);
                    IStepInfo stepInfo = this.clip.getStep(notePosition);
                    StepState stepState = stepInfo.getState();
                    if (stepState == StepState.OFF) continue;
                    double x = left + (double)step * stepWidth - 1.0;
                    double w = stepWidth + 2.0;
                    boolean bl = isStart = stepState == StepState.START;
                    if (isStart) {
                        x += 2.0;
                        w -= 2.0;
                    }
                    ColorEx colorEx = stepNoteBackgroundColor = stepInfo.isSelected() ? ColorEx.evenDarker(noteColor) : noteColor;
                    if (this.activePosition != null && this.activePosition.equals(notePosition)) {
                        stepNoteBackgroundColor = noteActiveColor;
                    } else if (stepInfo.isMuted()) {
                        stepNoteBackgroundColor = noteMutedColor;
                    }
                    gc.strokeRectangle(x, 14.0 + (double)(range - row - 1) * stepHeight + 2.0, w, stepHeight - 2.0, noteBorderColor);
                    gc.fillRectangle(x + (double)(isStart ? 0 : -2), 14.0 + (double)(range - row - 1) * stepHeight + 2.0, w - 1.0 + (double)(isStart ? 0 : 2), stepHeight - 3.0, stepNoteBackgroundColor);
                    if (!isStart || !(fontSize > 0.0)) continue;
                    String text = channel + 1 + ": " + Scales.formatDrumNote(notePosition.getNote());
                    ColorEx textColor = ColorEx.calcContrastColor(noteColor);
                    gc.drawTextInBounds(text, x, 14.0 + (double)(range - row - 1) * stepHeight + 2.0, w - 1.0, stepHeight - 3.0, Align.CENTER, textColor, fontSize);
                }
            }
        }
        int playStep = this.clip.getCurrentStep();
        if (playStep >= 0) {
            gc.fillRectangle(left + (double)playStep * stepWidth - 1.0, 0.0, 3.0, height, measureTextColor);
        }
    }
}

