/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn.mode;

import de.mossgrabers.controller.yaeltex.turn.YaeltexTurnConfiguration;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnColorManager;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnControlSurface;
import de.mossgrabers.controller.yaeltex.turn.view.DrumView;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.PanLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.SendLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.VolumeLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class YaeltexTurnDrumMixMode
extends AbstractParameterMode<YaeltexTurnControlSurface, YaeltexTurnConfiguration, ILayer> {
    protected final IEqualizerDevice eqDevice;
    protected final IDrumDevice drumDevice;
    protected final List<IParameterProvider> providers = new ArrayList<IParameterProvider>();
    protected final Scales scales;
    protected final YaeltexTurnConfiguration configuration = (YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration();
    private boolean showEvenPeriods = true;

    public YaeltexTurnDrumMixMode(YaeltexTurnControlSurface surface, IModel model, List<ContinuousID> controls) {
        this("Drum Machine Mixer", surface, model, controls);
        IDrumDevice drum = model.getDrumDevice();
        this.providers.add(0, new BankParameterProvider(drum.getParameterBank()));
        this.providers.add(0, new SendLayerOrDrumPadParameterProvider(drum, 1));
        this.providers.add(0, new SendLayerOrDrumPadParameterProvider(drum, 0));
        this.providers.add(0, new PanLayerOrDrumPadParameterProvider(drum));
        this.setParameterProvider(new CombinedParameterProvider(this.providers));
    }

    protected YaeltexTurnDrumMixMode(String name, YaeltexTurnControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(name, surface, model, true, model.getDrumDevice().getDrumPadBank(), controls);
        this.scales = model.getScales();
        this.drumDevice = model.getDrumDevice();
        this.eqDevice = (IEqualizerDevice)model.getSpecificDevice(DeviceID.EQ);
        this.providers.add(new FixedParameterProvider(this.eqDevice.getTypeParameters()));
        this.providers.add(new FixedParameterProvider(this.eqDevice.getQParameters()));
        this.providers.add(new FixedParameterProvider(this.eqDevice.getFrequencyParameters()));
        this.providers.add(new FixedParameterProvider(this.eqDevice.getGainParameters()));
        this.providers.add(new VolumeLayerOrDrumPadParameterProvider(this.drumDevice));
        this.drumDevice.addHasDrumPadsObserver(hasDrumPads -> this.parametersAdjusted());
        this.getDrumPadBank().addSelectionObserver(this::drumPadSelectionChanged);
    }

    @Override
    public void onActivate() {
        this.drumPadSelectionChanged(-1, true);
        super.onActivate();
    }

    @Override
    public int getKnobValue(int index) {
        int row = index / 8;
        int column = index % 8;
        IDrumPad drumPad = this.getDrumPad(column);
        switch (row) {
            case 0: {
                return drumPad.getPan();
            }
            case 1: {
                return ((ISend)drumPad.getSendBank().getItem(0)).getValue();
            }
            case 2: {
                return ((ISend)drumPad.getSendBank().getItem(1)).getValue();
            }
            case 3: {
                return this.getParameter(column).getValue();
            }
        }
        return 0;
    }

    @Override
    public int getKnobColor(int index) {
        int row = index / 8;
        int column = index % 8;
        ColorEx color = row < 3 ? this.getDrumPad(column).getColor() : ColorEx.WHITE;
        return YaeltexTurnColorManager.getIndexFor(color);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event == ButtonEvent.LONG) {
            return;
        }
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            if (event == ButtonEvent.DOWN) {
                this.onShiftButton(row, index);
            }
            return;
        }
        IDrumPad drumPad = this.getDrumPad(index);
        switch (row) {
            case 0: {
                this.handleRow0(index * 2, event == ButtonEvent.DOWN);
                break;
            }
            case 1: {
                this.handleRow0(index * 2 + 1, event == ButtonEvent.DOWN);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                if (((YaeltexTurnControlSurface)this.surface).isSelectPressed()) {
                    this.drumDevice.getDrumPadBank().clearSolo();
                    break;
                }
                drumPad.toggleSolo();
                break;
            }
            case 4: {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                if (((YaeltexTurnControlSurface)this.surface).isSelectPressed()) {
                    this.drumDevice.getDrumPadBank().clearMute();
                    break;
                }
                drumPad.toggleMute();
                break;
            }
            case 5: {
                if (event != ButtonEvent.DOWN) break;
                this.handleRow4(index);
                break;
            }
        }
    }

    protected void handleRow0(int index, boolean isPressed) {
        if (index < 8) {
            IMidiInput input = ((YaeltexTurnControlSurface)this.surface).getMidiInput();
            input.sendRawMidiEvent(isPressed ? 144 : 128, this.scales.getDrumOffset() + index, isPressed ? 127 : 0);
            return;
        }
        if (!isPressed) {
            return;
        }
        switch (index) {
            case 10: {
                this.configuration.toggleNoteRepeatActive();
                break;
            }
            case 11: {
                this.showEvenPeriods = !this.showEvenPeriods;
                break;
            }
            case 12: {
                this.setNoteRepeat(this.showEvenPeriods ? Resolution.RES_1_4 : Resolution.RES_1_4T);
                break;
            }
            case 13: {
                this.setNoteRepeat(this.showEvenPeriods ? Resolution.RES_1_8 : Resolution.RES_1_8T);
                break;
            }
            case 14: {
                this.setNoteRepeat(this.showEvenPeriods ? Resolution.RES_1_16 : Resolution.RES_1_16T);
                break;
            }
            case 15: {
                this.setNoteRepeat(this.showEvenPeriods ? Resolution.RES_1_32 : Resolution.RES_1_32T);
                break;
            }
        }
    }

    private void setNoteRepeat(Resolution noteRepeat) {
        this.configuration.setNoteRepeatPeriod(noteRepeat);
        this.mvHelper.delayDisplay(() -> "Repeat Period: " + noteRepeat.getName());
    }

    protected void handleRow4(int index) {
        this.getDrumPad(index).select();
        ((DrumView)((YaeltexTurnControlSurface)this.surface).getViewManager().get(Views.DRUM)).setSelectedPad(index);
    }

    protected void onShiftButton(int row, int index) {
        if (row == 0 || row == 1) {
            return;
        }
        if (row == 2 || row == 3) {
            int paramPageIndex = 2 * index + row - 2;
            this.drumDevice.getParameterBank().getPageBank().selectPage(paramPageIndex);
            this.mvHelper.notifyFirstDeviceAndParameterPage();
            return;
        }
        if (row == 5) {
            ((YaeltexTurnControlSurface)this.surface).getDisplay().notify(AbstractConfiguration.getNewClipLengthValue(index));
            ((YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration()).setNewClipLength(index);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            return this.getButtonShiftColor(buttonID);
        }
        int color = 0;
        switch (buttonID) {
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                color = this.getFirstRowButtonColor((buttonID.ordinal() - ButtonID.ROW1_1.ordinal()) * 2);
                break;
            }
            case ROW2_1: 
            case ROW2_2: 
            case ROW2_3: 
            case ROW2_4: 
            case ROW2_5: 
            case ROW2_6: 
            case ROW2_7: 
            case ROW2_8: {
                color = this.getFirstRowButtonColor((buttonID.ordinal() - ButtonID.ROW2_1.ordinal()) * 2 + 1);
                break;
            }
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: {
                break;
            }
            case ROW4_1: 
            case ROW4_2: 
            case ROW4_3: 
            case ROW4_4: 
            case ROW4_5: 
            case ROW4_6: 
            case ROW4_7: 
            case ROW4_8: {
                color = this.getDrumPad(buttonID, ButtonID.ROW4_1).isSolo() ? YaeltexTurnColorManager.YELLOW : 0;
                break;
            }
            case ROW5_1: 
            case ROW5_2: 
            case ROW5_3: 
            case ROW5_4: 
            case ROW5_5: 
            case ROW5_6: 
            case ROW5_7: 
            case ROW5_8: {
                color = this.getDrumPad(buttonID, ButtonID.ROW5_1).isMute() ? 7 : 0;
                break;
            }
            case ROW6_1: 
            case ROW6_2: 
            case ROW6_3: 
            case ROW6_4: 
            case ROW6_5: 
            case ROW6_6: 
            case ROW6_7: 
            case ROW6_8: {
                color = this.getFourthRowButtonColor(buttonID.ordinal() - ButtonID.ROW6_1.ordinal());
                break;
            }
        }
        return color;
    }

    protected int getFirstRowButtonColor(int index) {
        if (index < 8) {
            return this.getFourthRowButtonColor(index);
        }
        Resolution noteRepeatPeriod = this.configuration.getNoteRepeatPeriod();
        switch (index) {
            case 10: {
                return this.configuration.isNoteRepeatActive() ? YaeltexTurnColorManager.GREEN : 51;
            }
            case 11: {
                return this.showEvenPeriods ? 127 : YaeltexTurnColorManager.PINK;
            }
            case 12: {
                if (this.showEvenPeriods) {
                    return noteRepeatPeriod == Resolution.RES_1_4 ? 1 : 12;
                }
                return noteRepeatPeriod == Resolution.RES_1_4T ? YaeltexTurnColorManager.CYAN : 12;
            }
            case 13: {
                if (this.showEvenPeriods) {
                    return noteRepeatPeriod == Resolution.RES_1_8 ? 1 : 12;
                }
                return noteRepeatPeriod == Resolution.RES_1_8T ? YaeltexTurnColorManager.CYAN : 12;
            }
            case 14: {
                if (this.showEvenPeriods) {
                    return noteRepeatPeriod == Resolution.RES_1_16 ? 1 : 12;
                }
                return noteRepeatPeriod == Resolution.RES_1_16T ? YaeltexTurnColorManager.CYAN : 12;
            }
            case 15: {
                if (this.showEvenPeriods) {
                    return noteRepeatPeriod == Resolution.RES_1_32 ? 1 : 12;
                }
                return noteRepeatPeriod == Resolution.RES_1_32T ? YaeltexTurnColorManager.CYAN : 12;
            }
        }
        return 0;
    }

    protected int getFourthRowButtonColor(int index) {
        String drumPadColor = this.getDrumPadColor(index, this.drumDevice.getDrumPadBank());
        return this.colorManager.getColorIndex(drumPadColor);
    }

    private String getDrumPadColor(int index, IDrumPadBank drumPadBank) {
        int selectedPad = this.getDrumView().getSelectedPad();
        if (selectedPad == index) {
            return "COLOR_PAD_SELECTED";
        }
        IDrumPad drumPad = drumPadBank.getItem(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return ((YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration()).isTurnOffEmptyDrumPads() ? "COLOR_PAD_OFF" : "COLOR_PAD_NO_CONTENT";
        }
        if (drumPad.isMute() || drumPadBank.hasSoloedPads() && !drumPad.isSolo()) {
            return "COLOR_PAD_MUTED";
        }
        return DAWColor.getColorID(drumPad.getColor());
    }

    protected int getButtonShiftColor(ButtonID buttonID) {
        int deviceIndex = -1;
        int paramPageIndex = -1;
        switch (buttonID) {
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                deviceIndex = 2 * (buttonID.ordinal() - ButtonID.ROW1_1.ordinal());
                break;
            }
            case ROW2_1: 
            case ROW2_2: 
            case ROW2_3: 
            case ROW2_4: 
            case ROW2_5: 
            case ROW2_6: 
            case ROW2_7: 
            case ROW2_8: {
                deviceIndex = 2 * (buttonID.ordinal() - ButtonID.ROW2_1.ordinal()) + 1;
                break;
            }
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: {
                paramPageIndex = 2 * (buttonID.ordinal() - ButtonID.ROW3_1.ordinal());
                break;
            }
            case ROW4_1: 
            case ROW4_2: 
            case ROW4_3: 
            case ROW4_4: 
            case ROW4_5: 
            case ROW4_6: 
            case ROW4_7: 
            case ROW4_8: {
                paramPageIndex = 2 * (buttonID.ordinal() - ButtonID.ROW4_1.ordinal()) + 1;
                break;
            }
            case ROW6_1: 
            case ROW6_2: 
            case ROW6_3: 
            case ROW6_4: 
            case ROW6_5: 
            case ROW6_6: 
            case ROW6_7: 
            case ROW6_8: {
                int index = buttonID.ordinal() - ButtonID.ROW6_1.ordinal();
                return ((YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration()).getNewClipLength() == index ? YaeltexTurnColorManager.BLUE : 0;
            }
        }
        if (deviceIndex != -1) {
            return 0;
        }
        if (paramPageIndex != -1) {
            IParameterPageBank parameterPageBank = this.drumDevice.getParameterBank().getPageBank();
            String paramPage = (String)parameterPageBank.getItem(paramPageIndex);
            if (paramPage == null || paramPage.isBlank()) {
                return 0;
            }
            return paramPageIndex == parameterPageBank.getSelectedItemIndex() ? YaeltexTurnColorManager.BLUE : 127;
        }
        return 0;
    }

    private void drumPadSelectionChanged(int index, boolean isSelected) {
        Optional<ILayer> selectedDrumPad;
        if (!isSelected || !this.isActive) {
            return;
        }
        if (!this.eqDevice.doesExist() && (selectedDrumPad = this.getDrumPadBank().getSelectedItem()).isPresent()) {
            selectedDrumPad.get().addEqualizerDevice();
        }
    }

    @Override
    public void selectPreviousItem() {
        this.getDrumView().onOctaveDown(ButtonEvent.DOWN);
    }

    @Override
    public void selectNextItem() {
        this.getDrumView().onOctaveUp(ButtonEvent.DOWN);
    }

    @Override
    public void selectPreviousItemPage() {
        this.selectPreviousItem();
    }

    @Override
    public void selectNextItemPage() {
        this.selectNextItem();
    }

    @Override
    public boolean hasPreviousItem() {
        return this.getDrumView().isOctaveDownButtonOn();
    }

    @Override
    public boolean hasNextItem() {
        return this.getDrumView().isOctaveUpButtonOn();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.hasPreviousItem();
    }

    @Override
    public boolean hasNextItemPage() {
        return this.hasNextItem();
    }

    private IDrumPad getDrumPad(ButtonID buttonID, ButtonID firstButtinInRow) {
        return this.getDrumPad(buttonID.ordinal() - firstButtinInRow.ordinal());
    }

    private IDrumPad getDrumPad(int index) {
        return this.getDrumPadBank().getItem(index);
    }

    private IDrumPadBank getDrumPadBank() {
        return this.drumDevice.getDrumPadBank();
    }

    private IParameter getParameter(int index) {
        return (IParameter)this.drumDevice.getParameterBank().getItem(index);
    }

    protected DrumView getDrumView() {
        return (DrumView)((YaeltexTurnControlSurface)this.surface).getViewManager().get(Views.DRUM);
    }
}

