/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.view;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyPadGrid;
import de.mossgrabers.controller.novation.launchkey.maxi.view.DrumView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class DrumConfigView
extends AbstractView<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    public DrumConfigView(LaunchkeyMk3ControlSurface surface, IModel model) {
        super("Drum Configuration", surface, model);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        int col = index % 8;
        DrumView view = (DrumView)((LaunchkeyMk3ControlSurface)this.surface).getViewManager().get(Views.DRUM);
        if (index / 8 == 1) {
            view.setResolutionIndex(col);
            return;
        }
        INoteClip clip = view.getClip();
        switch (col) {
            case 0: {
                clip.scrollStepsPageBackwards();
                this.mvHelper.notifyEditPage(clip);
                break;
            }
            case 1: {
                clip.scrollStepsPageForward();
                this.mvHelper.notifyEditPage(clip);
                break;
            }
        }
    }

    @Override
    public void drawGrid() {
        DrumView view = (DrumView)((LaunchkeyMk3ControlSurface)this.surface).getViewManager().get(Views.DRUM);
        INoteClip clip = view.getClip();
        LaunchkeyPadGrid padGrid = ((LaunchkeyMk3ControlSurface)this.surface).getPadGrid();
        for (int x = 0; x < 8; ++x) {
            padGrid.lightEx(x, 0, view.getResolutionIndex() == x ? 45 : 47);
        }
        padGrid.lightEx(0, 1, clip.canScrollStepsBackwards() ? 17 : 19);
        padGrid.lightEx(1, 1, clip.canScrollStepsForwards() ? 17 : 19);
        padGrid.lightEx(2, 1, 0);
        padGrid.lightEx(3, 1, 0);
        padGrid.lightEx(4, 1, 0);
        padGrid.lightEx(5, 1, 0);
        padGrid.lightEx(6, 1, 0);
        padGrid.lightEx(7, 1, 0);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE1) {
            return 0;
        }
        return 3;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (buttonID == ButtonID.SCENE2 && event == ButtonEvent.UP) {
            ((LaunchkeyMk3ControlSurface)this.surface).getViewManager().restore();
        }
    }
}

