/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.BaseView;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.List;

public class NoteRepeatView
extends BaseView {
    public NoteRepeatView(MaschineControlSurface surface, IModel model) {
        super("Note Repeat", surface, model);
    }

    @Override
    public void executeFunction(int padIndex, ButtonEvent buttonEvent) {
        if (buttonEvent != ButtonEvent.DOWN) {
            return;
        }
        IHost host = this.model.getHost();
        MaschineConfiguration configuration = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
        switch (padIndex) {
            case 6: 
            case 7: {
                if (!host.supports(Capability.NOTE_REPEAT_MODE)) break;
                ArpeggiatorMode arpMode = configuration.getNoteRepeatMode();
                int modeIndex = configuration.lookupArpeggiatorModeIndex(arpMode);
                boolean increase = padIndex == 7;
                List<ArpeggiatorMode> modes = configuration.getArpeggiatorModes();
                int newIndex = Math.max(0, Math.min(modes.size() - 1, modeIndex + (increase ? 1 : -1)));
                configuration.setNoteRepeatMode(modes.get(newIndex));
                this.mvHelper.delayDisplay(() -> "Mode: " + configuration.getNoteRepeatMode().getName());
                break;
            }
            case 8: 
            case 9: {
                if (!host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                int sel2 = Resolution.change(Resolution.getMatch(configuration.getNoteRepeatLength().getValue()), padIndex == 9);
                configuration.setNoteRepeatLength(Resolution.values()[sel2]);
                ((MaschineControlSurface)this.surface).scheduleTask(() -> ((MaschineControlSurface)this.surface).getDisplay().notify("Note Length: " + Resolution.getNameAt(sel2)), 100L);
                break;
            }
            case 12: 
            case 13: {
                int sel = Resolution.change(Resolution.getMatch(configuration.getNoteRepeatPeriod().getValue()), padIndex == 13);
                configuration.setNoteRepeatPeriod(Resolution.values()[sel]);
                this.mvHelper.delayDisplay(() -> "Period: " + Resolution.getNameAt(sel));
                break;
            }
            case 14: 
            case 15: {
                if (!host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                configuration.setNoteRepeatOctave(configuration.getNoteRepeatOctave() + (padIndex == 15 ? 1 : -1));
                this.mvHelper.delayDisplay(() -> "Octaves: " + configuration.getNoteRepeatOctave());
                break;
            }
        }
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        for (i = 36; i < 42; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 42; i < 44; ++i) {
            padGrid.light(i, 42);
        }
        for (i = 44; i < 46; ++i) {
            padGrid.light(i, 30);
        }
        for (i = 46; i < 48; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 48; i < 50; ++i) {
            padGrid.light(i, 7);
        }
        for (i = 50; i < 52; ++i) {
            padGrid.light(i, 22);
        }
    }
}

