/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.mode;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.FaderConfig;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.mode.IMaschineJamMode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import java.util.Optional;

public class MaschineJamVolumeMode
extends TrackVolumeMode<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineJamMode {
    private static final FaderConfig FADER_OFF = new FaderConfig(1, 0, 0);

    public MaschineJamVolumeMode(MaschineJamControlSurface surface, IModel model) {
        super(surface, model, true, ContinuousID.createSequentialList(ContinuousID.FADER1, 8));
    }

    @Override
    public FaderConfig setupFader(int index) {
        Optional<ITrack> optionalTrack = this.getTrack(index);
        if (optionalTrack.isEmpty()) {
            return FADER_OFF;
        }
        ITrack track = optionalTrack.get();
        if (!track.doesExist()) {
            return FADER_OFF;
        }
        String c = DAWColor.getColorID(track.getColor());
        int color = this.colorManager.getColorIndex(c);
        int value = this.model.getValueChanger().toMidiValue(track.getVolume());
        if (!this.model.getTransport().isPlaying()) {
            return new FaderConfig(0, color, value);
        }
        int vu = this.model.getValueChanger().toMidiValue(track.getVu());
        return new FaderConfig(3, color, vu, value);
    }
}

