/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4.mode;

import de.mossgrabers.controller.faderfox.ec4.controller.EC4ControlSurface;
import de.mossgrabers.controller.faderfox.ec4.mode.AbstractEC4Mode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.parameter.MuteParameter;
import de.mossgrabers.framework.parameter.SoloParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.ArrayList;
import java.util.Optional;

public class EC4TrackMode
extends AbstractEC4Mode<ITrack> {
    public EC4TrackMode(EC4ControlSurface surface, IModel model) {
        super("Track", surface, model, model.getTrackBank());
        SelectedTrackParameterProvider trackProvider = new SelectedTrackParameterProvider(model);
        this.setParameterProvider(new CombinedParameterProvider(new RangeFilterParameterProvider(trackProvider, 0, 2), new FixedParameterProvider(new MuteParameter(model)), new FixedParameterProvider(new SoloParameter(model)), new RangeFilterParameterProvider(trackProvider, 2, 8), this.bottomRowProvider));
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (!this.isSession && row < 3) {
            if (event != ButtonEvent.DOWN) {
                return;
            }
            int trackIndex = row * 4 + column;
            if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
                if (selectedTrack.isEmpty()) {
                    return;
                }
                if (row == 0) {
                    switch (column) {
                        case 0: {
                            ((ITrack)selectedTrack.get()).resetVolume();
                            break;
                        }
                        case 1: {
                            ((ITrack)selectedTrack.get()).resetPan();
                            break;
                        }
                        case 2: {
                            ((ITrack)selectedTrack.get()).setMute(false);
                            break;
                        }
                        case 3: {
                            ((ITrack)selectedTrack.get()).setSolo(false);
                        }
                    }
                } else {
                    int sendIndex = (row - 1) * 4 + column;
                    ((ISend)((ITrack)selectedTrack.get()).getSendBank().getItem(sendIndex)).resetValue();
                }
            } else {
                ITrack track = (ITrack)this.model.getTrackBank().getItem(trackIndex);
                track.select();
                this.notifyTotalDisplay(track.getPosition() + 1 + ": " + track.getName());
            }
            return;
        }
        super.onButton(row, column, event);
    }

    @Override
    public void updateDisplay() {
        ArrayList<String[]> totalDisplayInfo = new ArrayList<String[]>();
        ITextDisplay display = ((EC4ControlSurface)this.surface).getTextDisplay().clear();
        display.setCell(0, 0, "Vol ").setCell(0, 1, "Pan ").setCell(0, 2, "Mute").setCell(0, 3, "Solo");
        display.setCell(1, 0, "Snd1").setCell(1, 1, "Snd2").setCell(1, 2, "Snd3").setCell(1, 3, "Snd4");
        display.setCell(2, 0, "Snd5").setCell(2, 1, "Snd6").setCell(2, 2, "Snd7").setCell(2, 3, "Snd8");
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        ITrack track = EmptyTrack.getInstance(8);
        if (selectedTrack.isPresent()) {
            track = (ITrack)selectedTrack.get();
            String trackName = track.getPosition() + 1 + ": " + track.getName();
            this.updateCache(0, track.getVolume(), totalDisplayInfo, trackName, "", "Volume: " + track.getVolumeStr());
            this.updateCache(1, track.getPan(), totalDisplayInfo, trackName, "", "Pan: " + track.getPanStr());
            this.updateCache(2, track.isMute() ? 127 : 0, totalDisplayInfo, trackName, "", "Mute: " + (track.isMute() ? "on" : "off"));
            this.updateCache(3, track.isSolo() ? 127 : 0, totalDisplayInfo, trackName, "", "Solo: " + (track.isSolo() ? "on" : "off"));
            ISendBank sendBank = track.getSendBank();
            for (int i = 0; i < 8; ++i) {
                ISend send = (ISend)sendBank.getItem(i);
                this.updateCache(4 + i, send.getValue(), totalDisplayInfo, trackName, "", i + 1 + ": " + send.getName(7) + ": " + send.getDisplayedValue());
            }
        }
        super.updateDisplayRow4(display, totalDisplayInfo, "Main");
        display.allDone();
        ((EC4ControlSurface)this.surface).fillTotalDisplay(totalDisplayInfo);
    }
}

