/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class FireConfiguration
extends AbstractConfiguration {
    private static final Views[] PREFERRED_NOTE_VIEWS = new Views[]{Views.PLAY, Views.PIANO, Views.DRUM64, Views.DRUM4, Views.SEQUENCER, Views.POLY_SEQUENCER};
    public static final Integer PAD_BRIGHTNESS = 50;
    public static final Integer PAD_SATURATION = 51;
    private int padBrightness = 100;
    private int padSaturation = 100;
    private boolean controlLastParam;
    private IEnumSetting controlLastParamSetting;

    public FireConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        IEnumSetting flipRecordSetting = globalSettings.getEnumSetting("Flip arranger and clip record", "Transport", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        flipRecordSetting.addValueObserver(value -> {
            this.flipRecord = "On".equals(value);
            this.notifyObservers(FLIP_RECORD);
        });
        this.isSettingActive.add(FLIP_RECORD);
        this.activateAccentActiveSetting(globalSettings);
        this.activateAccentValueSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateMidiEditChannelSetting(documentSettings);
        this.activateStartupViewSetting(globalSettings, PREFERRED_NOTE_VIEWS);
        this.activateStartWithSessionViewSetting(globalSettings);
        this.activateTurnOffScalePadsSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        if (this.host.supports(Capability.HAS_DRUM_DEVICE)) {
            this.activateTurnOffEmptyDrumPadsSetting(globalSettings);
        }
        this.activateUseCombinationButtonToSoundSetting(globalSettings);
        this.controlLastParamSetting = globalSettings.getEnumSetting("Control last touched/clicked parameter with SELECT", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.controlLastParamSetting.addValueObserver(value -> {
            this.controlLastParam = ON_OFF_OPTIONS[1].equals(value);
        });
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
        this.activateColorTrackStates(globalSettings);
        IIntegerSetting padBrightnessSetting = globalSettings.getRangeSetting("Pad Brightness", "Hardware Setup", 0, 100, 1, "%", 20);
        padBrightnessSetting.addValueObserver(value -> {
            this.padBrightness = value;
            this.notifyObservers(PAD_BRIGHTNESS);
        });
        this.isSettingActive.add(PAD_BRIGHTNESS);
        IIntegerSetting padSaturationSetting = globalSettings.getRangeSetting("Pad Saturation", "Hardware Setup", 0, 100, 1, "%", 100);
        padSaturationSetting.addValueObserver(value -> {
            this.padSaturation = value;
            this.notifyObservers(PAD_SATURATION);
        });
        this.isSettingActive.add(PAD_SATURATION);
    }

    public int getPadBrightness() {
        return this.padBrightness;
    }

    public int getPadSaturation() {
        return this.padSaturation;
    }

    public boolean isControlLastParam() {
        return this.controlLastParam;
    }

    public void toggleControlLastParam() {
        this.controlLastParamSetting.set(ON_OFF_OPTIONS[this.controlLastParam ? 0 : 1]);
    }
}

