/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device;

import com.nikhaldimann.inieditor.IniEditor;
import de.mossgrabers.reaper.framework.IniFiles;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMap;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPage;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPageParameter;
import de.mossgrabers.reaper.framework.device.DeviceCollection;
import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceMetadataImpl;
import de.mossgrabers.reaper.framework.device.DeviceType;
import de.mossgrabers.reaper.ui.utils.LogModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceManager {
    private static final DeviceManager INSTANCE = new DeviceManager();
    private static final String SECTION_FOLDERS = "Folders";
    private static final Pattern PATTERN_NAME = Pattern.compile("(?<type>[^:]+?)(?<instrument>i?):\\s*(?<name>([^)])+)(\\s*\\((?<company>[^)]+?)\\))?(\\s*\\((?<channels>[^)]+)\\))?");
    private static final Set<String> NON_CATEGORIES = Set.of("ix", "till", "loser", "liteon", "sstillwell", "teej", "schwa", "u-he", "remaincalm_org");
    private static final Map<Integer, DeviceFileType> TYPE_CODES = new HashMap<Integer, DeviceFileType>(5);
    private static final Map<String, DeviceFileType> DEVICE_FILE_TYPE_MAP = new HashMap<String, DeviceFileType>();
    private static final Map<String, String> JS_CATEGORY_MAP = new HashMap<String, String>();
    private static final Map<String, List<String>> KNOWN_PLUGIN_CATEGORIES_MAP = new HashMap<String, List<String>>();
    private final List<DeviceMetadataImpl> devices = new ArrayList<DeviceMetadataImpl>();
    private final List<DeviceMetadataImpl> instruments = new ArrayList<DeviceMetadataImpl>();
    private final List<DeviceMetadataImpl> effects = new ArrayList<DeviceMetadataImpl>();
    private final Set<String> categories = new TreeSet<String>();
    private final Set<String> vendors = new TreeSet<String>();
    private final List<DeviceCollection> collections = new ArrayList<DeviceCollection>();
    private final Set<DeviceFileType> availableFileTypes = new TreeSet<DeviceFileType>();
    private final Map<String, ParameterMap> parameterMaps = new HashMap<String, ParameterMap>();
    private final List<DeviceFileType> preferredTypes = new ArrayList<DeviceFileType>();
    private IniFiles iniFiles;

    private DeviceManager() {
    }

    public static DeviceManager get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumDevices() {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            return this.devices.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceMetadataImpl> getAll() {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            return new ArrayList<DeviceMetadataImpl>(this.devices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceMetadataImpl> getInstruments() {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            return new ArrayList<DeviceMetadataImpl>(this.instruments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceMetadataImpl> getEffects() {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            return new ArrayList<DeviceMetadataImpl>(this.effects);
        }
    }

    public List<DeviceMetadataImpl> filterByFileType(DeviceFileType deviceFileType) {
        return this.filterBy(deviceFileType, null, null, null, null);
    }

    public List<DeviceMetadataImpl> filterByCategory(String category) {
        return this.filterBy(null, category, null, null, null);
    }

    public List<DeviceMetadataImpl> filterByVendor(String vendor) {
        return this.filterBy(null, null, vendor, null, null);
    }

    public List<DeviceMetadataImpl> filterByCollection(DeviceCollection collection) {
        return this.filterBy(null, null, null, collection, null);
    }

    public List<DeviceMetadataImpl> filterByType(DeviceType deviceType) {
        return this.filterBy(null, null, null, null, deviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceMetadataImpl> filterBy(DeviceFileType fileType, String category, String vendor, DeviceCollection collection, DeviceType deviceType) {
        List<DeviceMetadataImpl> results = new ArrayList<DeviceMetadataImpl>();
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            for (DeviceMetadataImpl d : this.devices) {
                if (!DeviceManager.accept(d, fileType, category, vendor, deviceType)) continue;
                results.add(d);
            }
        }
        if (collection != null) {
            results = collection.filter(results);
        }
        return this.filterPreferredFileTypes(results);
    }

    private List<DeviceMetadataImpl> filterPreferredFileTypes(List<DeviceMetadataImpl> results) {
        List<DeviceFileType> prefTypes = this.getPreferredTypes();
        if (prefTypes.isEmpty() || results.size() <= 1) {
            return results;
        }
        TreeMap<String, Map> identicalDevices = new TreeMap<String, Map>();
        for (DeviceMetadataImpl device : results) {
            String deviceName = device.name();
            identicalDevices.computeIfAbsent(deviceName, name -> new EnumMap(DeviceFileType.class)).put(device.getFileType(), device);
        }
        ArrayList<DeviceMetadataImpl> resultsFiltered = new ArrayList<DeviceMetadataImpl>();
        for (Map deviceOptions : identicalDevices.values()) {
            DeviceFileType prefType;
            DeviceMetadataImpl deviceMetadata = null;
            Iterator<DeviceFileType> iterator = prefTypes.iterator();
            while (iterator.hasNext() && (deviceMetadata = (DeviceMetadataImpl)deviceOptions.get((Object)(prefType = iterator.next()))) == null) {
            }
            if (deviceMetadata == null) {
                resultsFiltered.addAll(deviceOptions.values());
                continue;
            }
            resultsFiltered.add(deviceMetadata);
        }
        return resultsFiltered;
    }

    private static boolean accept(DeviceMetadataImpl d, DeviceFileType fileType, String category, String vendor, DeviceType deviceType) {
        if (fileType != null && d.getFileType() != fileType || category != null && !d.hasCategory(category)) {
            return false;
        }
        if (vendor != null && !vendor.equals(d.getVendor())) {
            return false;
        }
        return deviceType == null || d.getType() == deviceType;
    }

    private List<DeviceFileType> getPreferredTypes() {
        if (this.iniFiles == null) {
            return Collections.emptyList();
        }
        int pattern = this.iniFiles.getMainIniInteger("REAPER-fxadd", "dupefilter", 0);
        this.preferredTypes.clear();
        for (int i = 0; i < 4; ++i) {
            int code = pattern >> i * 4 & 0xF;
            DeviceFileType type = TYPE_CODES.get(code);
            if (type == null) continue;
            this.preferredTypes.add(type);
        }
        return this.preferredTypes;
    }

    public void addDeviceInfo(String description, String module) {
        Matcher matcher = PATTERN_NAME.matcher(description);
        if (!matcher.matches()) {
            return;
        }
        Object deviceName = matcher.group("name").trim();
        if (deviceName == null) {
            return;
        }
        String channels = matcher.group("channels");
        if (channels != null) {
            deviceName = (String)deviceName + " (" + channels + ")";
        }
        String instrument = matcher.group("instrument");
        String type = matcher.group("type");
        if (type == null) {
            return;
        }
        DeviceFileType fileType = DEVICE_FILE_TYPE_MAP.get(type);
        if (fileType == null) {
            return;
        }
        DeviceType deviceType = instrument != null && "i".equals(instrument) ? DeviceType.INSTRUMENT : DeviceType.AUDIO_EFFECT;
        String category = null;
        String company = matcher.group("company");
        if (fileType == DeviceFileType.JS) {
            String[] modulePath;
            if (company != null && !"Cockos".equals(company)) {
                deviceName = (String)deviceName + " (" + company + ")";
                company = null;
            }
            if ((modulePath = module.split("/")).length <= 1) {
                return;
            }
            if (NON_CATEGORIES.contains(modulePath[0].toLowerCase(Locale.US))) {
                company = modulePath[0];
            } else {
                String mappedCategory = JS_CATEGORY_MAP.get(modulePath[0]);
                category = mappedCategory == null ? modulePath[0] : mappedCategory;
            }
        }
        DeviceMetadataImpl device = new DeviceMetadataImpl((String)deviceName, module, deviceType, fileType);
        if (company != null) {
            device.setVendor(company);
            this.vendors.add(company);
        }
        if (category != null) {
            device.addCategory(category);
            this.categories.add(category);
        }
        this.devices.add(device);
        if (deviceType == DeviceType.INSTRUMENT) {
            this.instruments.add(device);
        } else {
            this.effects.add(device);
        }
        this.availableFileTypes.add(fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDeviceInfo(IniFiles iniFiles, LogModel logModel) {
        this.iniFiles = iniFiles;
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            if (iniFiles.isFxTagsPresent()) {
                TreeSet<String> vendorsSet = new TreeSet<String>();
                TreeSet<String> categoriesSet = new TreeSet<String>();
                this.parseFXTagsFile(iniFiles.getIniFxTags(), categoriesSet, vendorsSet);
                this.categories.addAll(categoriesSet);
                this.vendors.addAll(vendorsSet);
            }
            if (iniFiles.isFxFoldersPresent()) {
                this.parseCollectionFilters(iniFiles.getIniFxFolders());
            }
            if (iniFiles.isParamMapsPresent()) {
                this.parseParameterMaps(iniFiles.getIniParamMaps());
            }
            for (DeviceMetadataImpl device : this.devices) {
                if (!device.isCategorized()) {
                    String deviceName = device.name();
                    String category = DeviceManager.findCategory(deviceName);
                    if (category != null) {
                        device.addCategory(category);
                    }
                } else if (device.hasCategory("MIDI")) {
                    device.setType(DeviceType.MIDI_EFFECT);
                }
                if (device.hasCategory("Utility")) {
                    device.setCategory("Tools");
                    this.categories.add("Tools");
                }
                if (!device.hasCategory("Pitch Shift")) continue;
                device.setCategory("Pitch");
                this.categories.add("Pitch");
            }
            this.categories.remove("Utility");
            this.categories.remove("Pitch");
            this.devices.sort((d1, d2) -> d1.getDisplayName().compareToIgnoreCase(d2.getDisplayName()));
        }
    }

    private static String findCategory(String deviceName) {
        for (Map.Entry<String, List<String>> entry : KNOWN_PLUGIN_CATEGORIES_MAP.entrySet()) {
            for (String value : entry.getValue()) {
                if (!deviceName.contains(value)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public List<DeviceFileType> getAvailableFileTypes() {
        return new ArrayList<DeviceFileType>(this.availableFileTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCategories() {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            return new ArrayList<String>(this.categories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getVendors() {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            return new ArrayList<String>(this.vendors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceCollection> getCollections() {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            return this.collections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceCollection getCollection(String collectionName) {
        List<DeviceMetadataImpl> list = this.devices;
        synchronized (list) {
            for (DeviceCollection collection : this.collections) {
                if (!collection.getName().equals(collectionName)) continue;
                return collection;
            }
        }
        return null;
    }

    public Map<String, ParameterMap> getParameterMaps() {
        return this.parameterMaps;
    }

    private void parseFXTagsFile(IniEditor iniFile, Set<String> categoriesSet, Set<String> vendorsSet) {
        for (DeviceMetadataImpl d : this.devices) {
            String vendor;
            String categoriesStr = iniFile.get("category", d.getModule());
            if (categoriesStr != null) {
                HashSet<String> cats = new HashSet<String>();
                for (String category : categoriesStr.split("\\|")) {
                    if (NON_CATEGORIES.contains(category)) continue;
                    cats.add(category);
                }
                if (cats.isEmpty()) {
                    DeviceType type = d.getType();
                    if (type == DeviceType.INSTRUMENT) {
                        cats.add("Synth");
                    } else if (type == DeviceType.MIDI_EFFECT) {
                        cats.add("MIDI");
                    }
                }
                d.addCategories(cats);
                categoriesSet.addAll(cats);
            }
            if ((vendor = iniFile.get("developer", d.getModule())) == null) continue;
            d.setVendor(vendor);
            vendorsSet.add(vendor);
        }
    }

    private void parseCollectionFilters(IniEditor iniFile) {
        for (int i = 0; i < DeviceManager.getInt(iniFile, SECTION_FOLDERS, "NbFolders", 0); ++i) {
            String collectionName;
            int id = DeviceManager.getInt(iniFile, SECTION_FOLDERS, "Id" + i, -1);
            if (id < 0 || (collectionName = iniFile.get(SECTION_FOLDERS, "Name" + i)) == null) continue;
            DeviceCollection deviceCollection = new DeviceCollection(collectionName);
            this.collections.add(deviceCollection);
            String collectionSection = "Folder" + id;
            for (int j = 0; j < DeviceManager.getInt(iniFile, collectionSection, "Nb", 0); ++j) {
                String item = iniFile.get(collectionSection, "Item" + j);
                if (item == null) continue;
                int type = DeviceManager.getInt(iniFile, collectionSection, "Type" + j, 0);
                deviceCollection.addItem(item, type);
            }
        }
    }

    private void parseParameterMaps(IniEditor iniFile) {
        for (String name : iniFile.sectionNames()) {
            String pageName;
            Map sectionMap = iniFile.getSectionMap(name);
            ParameterMap parameterMap = new ParameterMap(name);
            List<ParameterMapPage> pages = parameterMap.getPages();
            int i = 0;
            while ((pageName = (String)sectionMap.get("page" + i)) != null) {
                String[] parts;
                ParameterMapPage page = new ParameterMapPage(pageName);
                String params = (String)sectionMap.get("params" + i);
                if (params == null || (parts = params.split(",")).length != 16) break;
                List<ParameterMapPageParameter> parameters = page.getParameters();
                for (int p = 0; p < 16; p += 2) {
                    parameters.get(p / 2).assign(Integer.parseInt(parts[p]), parts[p + 1]);
                }
                pages.add(page);
                ++i;
            }
            this.parameterMaps.put(name, parameterMap);
        }
    }

    private static int getInt(IniEditor iniFile, String category, String name, int defaultValue) {
        String value = iniFile.get(category, name);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    static {
        TYPE_CODES.put(1, DeviceFileType.VST3);
        TYPE_CODES.put(2, DeviceFileType.VST2);
        TYPE_CODES.put(3, DeviceFileType.AU);
        TYPE_CODES.put(4, DeviceFileType.LV2);
        TYPE_CODES.put(5, DeviceFileType.CLAP);
        DEVICE_FILE_TYPE_MAP.put("VST3", DeviceFileType.VST3);
        DEVICE_FILE_TYPE_MAP.put("VST", DeviceFileType.VST2);
        DEVICE_FILE_TYPE_MAP.put("AU", DeviceFileType.AU);
        DEVICE_FILE_TYPE_MAP.put("LV2", DeviceFileType.LV2);
        DEVICE_FILE_TYPE_MAP.put("CLAP", DeviceFileType.CLAP);
        DEVICE_FILE_TYPE_MAP.put("JS", DeviceFileType.JS);
        JS_CATEGORY_MAP.put("analysis", "Analysis");
        JS_CATEGORY_MAP.put("delay", "Delay");
        JS_CATEGORY_MAP.put("dynamics", "Dynamics");
        JS_CATEGORY_MAP.put("filters", "Filter");
        JS_CATEGORY_MAP.put("guitar", "Guitar");
        JS_CATEGORY_MAP.put("loopsamplers", "Sampler");
        JS_CATEGORY_MAP.put("meters", "Analysis");
        JS_CATEGORY_MAP.put("midi", "MIDI");
        JS_CATEGORY_MAP.put("misc", "Misc");
        JS_CATEGORY_MAP.put("old_unsupported", "Misc");
        JS_CATEGORY_MAP.put("pitch", "Pitch");
        JS_CATEGORY_MAP.put("synthesis", "Synth");
        JS_CATEGORY_MAP.put("utility", "Tools");
        JS_CATEGORY_MAP.put("waveshapers", "Modulation");
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Delay", List.of("ColourCopy", "Delay", "MFM2", "ReaDelay", "Replika", "ValhallaDelay", "Ping Pong"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Distortion", List.of("Bite", "Dirt", "COLDFIRE", "Dist", "Trash", "Saturation", "Vinyl", "Paranoia Mangler", "Tape MELLO-FI"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Dynamics", List.of("Bus", "Comp", "Expander", "Exciter", "Nectar", "Neutron", "Ozone", "ReaLimit", "Satin", "Solid Bus Comp", "Solid Dynamics", "Supercharger", "Limiter", "Gate", "Transient", "Presswerk", "ReaComp", "ReaXcomp", "Vari Comp", "Enhancer", "Loud", "Satin", "Compciter", "Stereo Upmix", "Zero Crossing Maximizer", "Event Horizon Clipper", "Stereo Width", "Thunderkick", "Booster", "De-esser"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("EQ", List.of("EQ", "Equalizer", "Kicker"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Filter", List.of("Driver", "Filter", "ReaFir"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Granular", List.of("FRAGMENTS", "REFRACT"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Guitar", List.of("Pre", "VC"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("MIDI", List.of("Captain", "SChord", "MIDI"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Misc", List.of("RX", "SpectraLayers", "Lorenz Attractor", "WaveLab"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Modulation", List.of("Choral", "Chorus", "MOTIONS", "Flair", "Flange", "Stutter", "Ring Modulator", "Waveshaper", "Phasis", "Modulator", "Phaser", "Rotary"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Multi", List.of("Guitar Rig", "KAOSS", "Surge XT Effects"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Pitch", List.of("Melodyne", "ReaPitch", "ReaTune"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Reverb", List.of("Raum", "RC", "ReaVerb", "ReaVerbate", "INTENSITY", "ValhallaRoom", "ValhallaShimmer", "ValhallaSupermassive", "ValhallaVintageVerb", "Twangstrom", "Zebrify", "ZRev", "PLATE", "SPRING", "LX-24", "MDE-X"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Sampler", List.of("ReaSamplOmatic5000", "sforzando", "Synclavier", "TAL Sampler", "TX16Wx", "Kontakt"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Synth", List.of("Absynth", "ACE", "Acid", "Analog Lab", "ARP", "Augmented", "B-3", "Battery", "Bazille", "Easel", "Cardinal", "Clavinet", "CMI", "CP-70", "CS-80", "CZ", "DecentSampler", "Diva", "DX7", "Emulator", "Fabric", "Farfisa", "FM8", "Freak", "Hive", "Hype", "Massive", "Mellotron", "microKORG", "Microwave", "MiniBrute", "MiniFreak", "miniKORG", "Modular", "modwave", "MODX", "MonoPoly", "opsix", "Organ", "Padshop", "Piano", "Pigments", "Polysix", "Prophecy", "Prophet", "ReaSynth", "Retrologue", "SEM", "sfizz", "sforzando", "Synth1", "Synthi", "Solina", "SQ80", "Super 8", "TRITON", "VOX Continental", "VOX Super Continental", "wavestate", "Wurli", "Zebra", "Mini D", "Mini V", "ELECTRIBE", "EP-1", "Groove Agent", "HALion", "Jun-6", "Jup-8", "Komplete", "MS-20", "M1", "Maschine", "Matrix-12", "K1v", "Omnisphere", "OP-Xa", "OPx-4", "Reaktor", "ReaSynDr", "Repro", "Stage-73", "Surge XT", "Avenger", "WAVESTATION", "XO (18 out)"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Tools", List.of("Tune", "ReaCast", "ReaControlMIDI", "ReaInsert", "ReaNINJAM", "ReaSurround", "ReaSurroundPan", "Stereo Mixer", "Polarity", "SwixMitch", "Generator", "Meter", "FFT", "Statistics", "Center Canceler", "Stereo Field Manipulator", "Time Difference Pan", "Goniometer", "Joiner", "Splitter", "Switcher", "ReaStream", "Pseudo-Stereo", "Non-Linear Processor", "Auto-Wideness"));
        KNOWN_PLUGIN_CATEGORIES_MAP.put("Vocal", List.of("ReaVocode", "ReaVoice", "VocalSynth", "Vocoder", "Speek"));
    }
}

