/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.color;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorIndexException;
import de.mossgrabers.framework.daw.DAWColor;
import java.util.HashMap;
import java.util.Map;

public class ColorManager {
    public static final String BUTTON_STATE_OFF = "BUTTON_STATE_OFF";
    public static final String BUTTON_STATE_ON = "BUTTON_STATE_ON";
    public static final String BUTTON_STATE_HI = "BUTTON_STATE_HI";
    protected final Map<String, Integer> colorIndexByKey = new HashMap<String, Integer>();
    protected final Map<Integer, ColorEx> colorByIndex = new HashMap<Integer, ColorEx>();

    public void registerColorIndex(String key, int colorIndex) {
        if (this.colorIndexByKey.containsKey(key)) {
            throw new ColorIndexException("Color for key " + key + " is already registered!");
        }
        this.updateColorIndex(key, colorIndex);
    }

    public void updateColorIndex(String key, int colorIndex) {
        this.colorIndexByKey.put(key, colorIndex);
    }

    public void registerColorIndex(DAWColor dawColor, int colorIndex) {
        this.registerColorIndex(dawColor.name(), colorIndex);
    }

    public int getColorIndex(String key) {
        Integer colorIndex = this.colorIndexByKey.get(key);
        if (colorIndex == null) {
            throw new ColorIndexException("Color for key " + key + " is not registered!");
        }
        return colorIndex;
    }

    public void registerColor(int colorIndex, ColorEx color) {
        if (colorIndex < 0 || colorIndex > 127) {
            throw new ColorIndexException("Color index must be in the range of 0..127!");
        }
        this.colorByIndex.put(colorIndex, color);
    }

    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        if (colorIndex < 0) {
            return ColorEx.BLACK;
        }
        ColorEx color = this.colorByIndex.get(colorIndex);
        if (color == null) {
            throw new ColorIndexException("Color for index " + colorIndex + " is not registered!");
        }
        return color;
    }
}

