/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.AbstractPlayView;
import de.mossgrabers.framework.view.Views;

public class PlayView
extends AbstractPlayView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    private static final int[] MODULATION_INTENSITIES = new int[]{0, 32, 64, 92, 127};
    private boolean playControls = false;
    private boolean isSustain = false;
    private boolean isPitchDown = false;
    private boolean isPitchUp = false;
    private int isModulation = 0;

    public PlayView(LaunchpadControlSurface surface, IModel model) {
        this("Play", surface, model);
    }

    public PlayView(String name, LaunchpadControlSurface surface, IModel model) {
        super(name, surface, model, true);
        Object configuration = ((LaunchpadControlSurface)this.surface).getConfiguration();
        configuration.addSettingObserver(AbstractConfiguration.ACTIVATE_FIXED_ACCENT, () -> this.initMaxVelocity());
        configuration.addSettingObserver(AbstractConfiguration.FIXED_ACCENT_VALUE, () -> this.initMaxVelocity());
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return 0;
        }
        switch (buttonID) {
            case SCENE1: 
            case SCENE2: 
            case SCENE7: 
            case SCENE8: {
                return 41;
            }
            case SCENE4: {
                return this.playControls ? 21 : 23;
            }
            case SCENE5: {
                return 11;
            }
            case SCENE6: {
                return this.scales.isChromatic() ? 3 : 1;
            }
        }
        return 0;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        ITextDisplay display = ((LaunchpadControlSurface)this.surface).getTextDisplay();
        switch (buttonID) {
            case SCENE1: {
                this.scales.nextScaleLayout();
                String name = this.scales.getScaleLayout().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleLayout(name);
                display.notify(name);
                break;
            }
            case SCENE2: {
                this.scales.prevScaleLayout();
                String name = this.scales.getScaleLayout().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleLayout(name);
                display.notify(name);
                break;
            }
            case SCENE4: {
                this.playControls = !this.playControls;
                this.setBlockedNotes(this.playControls ? 8 : 0);
                break;
            }
            case SCENE5: {
                this.activatePreferredView(Views.CHORDS);
                return;
            }
            case SCENE6: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                display.notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case SCENE7: {
                this.scales.setScaleOffsetByIndex(this.scales.getScaleOffsetIndex() + 1);
                String name = Scales.BASES.get(this.scales.getScaleOffsetIndex());
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleBase(name);
                display.notify(name);
                break;
            }
            case SCENE8: {
                this.scales.setScaleOffsetByIndex(this.scales.getScaleOffsetIndex() - 1);
                String name = Scales.BASES.get(this.scales.getScaleOffsetIndex());
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleBase(name);
                display.notify(name);
                break;
            }
        }
        this.updateNoteMapping();
    }

    @Override
    public void drawGrid() {
        super.drawGrid();
        if (!this.playControls) {
            return;
        }
        IPadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        int startNote = this.scales.getStartNote();
        padGrid.light(startNote, this.isSustain ? 13 : 15);
        padGrid.light(startNote + 1, this.isPitchDown ? 33 : 35);
        padGrid.light(startNote + 2, this.isPitchUp ? 33 : 35);
        for (int i = 0; i < 5; ++i) {
            padGrid.light(startNote + 3 + i, this.isModulation == i ? 53 : 55);
        }
    }

    @Override
    public void onGridNote(int key, int velocity) {
        int pos;
        if (this.playControls && (pos = key - this.scales.getStartNote()) < 8) {
            boolean isDown = velocity > 0;
            IMidiInput midiInput = ((LaunchpadControlSurface)this.surface).getMidiInput();
            switch (pos) {
                case 0: {
                    this.isSustain = isDown;
                    midiInput.sendRawMidiEvent(176, 64, this.isSustain ? 127 : 0);
                    return;
                }
                case 1: {
                    this.isPitchDown = isDown;
                    midiInput.sendRawMidiEvent(224, 0, this.isPitchDown ? Math.abs(velocity / 2 - 63) : 64);
                    return;
                }
                case 2: {
                    this.isPitchUp = isDown;
                    midiInput.sendRawMidiEvent(224, 0, this.isPitchUp ? 64 + velocity / 2 : 64);
                    return;
                }
            }
            if (isDown) {
                this.isModulation = pos - 3;
                midiInput.sendRawMidiEvent(176, 1, MODULATION_INTENSITIES[this.isModulation]);
            }
            return;
        }
        super.onGridNote(key, velocity);
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        int octave = this.scales.getOctave();
        int scale = this.scales.getScale().ordinal();
        scrollStates.setCanScrollLeft(scale > 0);
        scrollStates.setCanScrollRight(scale < Scale.values().length - 1);
        scrollStates.setCanScrollUp(octave < 3);
        scrollStates.setCanScrollDown(octave > -3);
    }
}

