/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.mode;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.FaderConfig;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.mode.IMaschineJamMode;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.track.TrackSendMode;
import java.util.Optional;

public class MaschineJamSendMode
extends TrackSendMode<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineJamMode {
    private static final FaderConfig FADER_OFF = new FaderConfig(1, 0, 0);

    public MaschineJamSendMode(int sendIndex, MaschineJamControlSurface surface, IModel model) {
        super(sendIndex, surface, model, true, ContinuousID.createSequentialList(ContinuousID.FADER1, 8));
    }

    @Override
    public FaderConfig setupFader(int index) {
        Optional<ITrack> optionalTrack = this.getTrack(index);
        if (optionalTrack.isEmpty()) {
            return FADER_OFF;
        }
        ITrack track = optionalTrack.get();
        if (!track.doesExist()) {
            return FADER_OFF;
        }
        ISend send = (ISend)track.getSendBank().getItem(this.sendIndex);
        if (!send.doesExist()) {
            return FADER_OFF;
        }
        int value = this.model.getValueChanger().toMidiValue(send.getValue());
        return new FaderConfig(0, 76, value);
    }
}

