/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.track;

import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;

public abstract class AbstractTrackMode
extends BaseMode<ITrack> {
    protected AbstractTrackMode(String name, MCUControlSurface surface, IModel model) {
        super(name, surface, model, model.getCurrentTrackBank());
        model.addTrackBankObserver(x$0 -> this.switchBanks(x$0));
    }

    @Override
    public void updateDisplay() {
        super.updateDisplay();
        this.updateItemIndices();
    }

    protected void updateItemIndices() {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        int extenderOffset = this.getExtenderOffset();
        int[] indices = new int[8];
        for (int i = 0; i < 8; ++i) {
            ITrack item = (ITrack)trackBank.getItem(extenderOffset + i);
            indices[i] = item.doesExist() ? item.getPosition() + 1 : 0;
        }
        ((MCUControlSurface)this.surface).setItemIndices(indices);
    }
}

