/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.ElectraOneConfiguration;
import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class SessionMode
extends AbstractElectraOneMode {
    private static final int FIRST_TRACK_GROUP = 550;
    public static final String COLOR_SCENE = "COLOR_SCENE";
    public static final String COLOR_SELECTED_SCENE = "COLOR_SELECTED_SCENE";
    public static final String COLOR_SCENE_OFF = "COLOR_SELECTED_OFF";
    private static final String[] FUNCTION_NAMES = new String[]{"New", "Delete", "Duplicate", "Quantize", "Stop"};
    private static final String[] NAVIGATION_NAMES = new String[]{"Tracks -", "Tracks +", "", "Scenes -", "Scenes+"};
    private static final ColorEx[] NAVIGATION_COLORS = new ColorEx[]{ColorEx.PURPLE, ColorEx.PURPLE, ColorEx.BLACK, ColorEx.OLIVE, ColorEx.OLIVE};
    private final ITransport transport;
    private final IMasterTrack masterTrack;
    private SessionUI sessionUI = SessionUI.NORMAL;
    private int clipFunction = 4;

    public SessionMode(ElectraOneControlSurface surface, IModel model) {
        super(5, "Session", surface, model);
        this.transport = this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        EmptyParameterProvider emptyParameterProvider = new EmptyParameterProvider(5);
        EmptyParameterProvider emptyParameterProvider2 = new EmptyParameterProvider(1);
        this.setParameterProvider(new CombinedParameterProvider(emptyParameterProvider, new FixedParameterProvider(this.masterTrack.getVolumeParameter()), emptyParameterProvider, new FixedParameterProvider(new PlayPositionParameter(model.getValueChanger(), this.transport, surface)), emptyParameterProvider, emptyParameterProvider2, emptyParameterProvider, emptyParameterProvider2, emptyParameterProvider, emptyParameterProvider2, emptyParameterProvider, emptyParameterProvider2));
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event == ButtonEvent.LONG) {
            return;
        }
        if (index == 5) {
            if (event != ButtonEvent.DOWN) {
                return;
            }
            switch (row) {
                case 2: {
                    this.sessionUI = this.sessionUI == SessionUI.NAVIGATION ? SessionUI.NORMAL : SessionUI.NAVIGATION;
                    break;
                }
                case 3: {
                    this.sessionUI = this.sessionUI == SessionUI.FUNCTIONS ? SessionUI.NORMAL : SessionUI.FUNCTIONS;
                    break;
                }
                case 4: {
                    this.transport.startRecording();
                    break;
                }
                case 5: {
                    this.playCommand.execute(ButtonEvent.UP, 127);
                    break;
                }
            }
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        ISceneBank sceneBank = this.model.getSceneBank();
        ElectraOneConfiguration configuration = (ElectraOneConfiguration)((ElectraOneControlSurface)this.surface).getConfiguration();
        if (row == 0) {
            switch (this.sessionUI.ordinal()) {
                case 0: {
                    ((IScene)sceneBank.getItem(index)).launch(event == ButtonEvent.DOWN, false);
                    break;
                }
                case 1: {
                    if (event != ButtonEvent.DOWN) break;
                    this.clipFunction = index;
                    break;
                }
                case 2: {
                    if (event != ButtonEvent.DOWN) break;
                    if (index == 0) {
                        tb.selectPreviousPage();
                        break;
                    }
                    if (index == 1) {
                        tb.selectNextPage();
                        break;
                    }
                    if (index == 3) {
                        sceneBank.selectPreviousPage();
                        break;
                    }
                    if (index != 4) break;
                    sceneBank.selectNextPage();
                }
            }
            return;
        }
        ITrack track = (ITrack)tb.getItem(row - 1);
        if (!track.doesExist()) {
            return;
        }
        ISlot slot = (ISlot)track.getSlotBank().getItem(index);
        block11 : switch (this.sessionUI.ordinal()) {
            case 0: {
                if (!slot.doesExist()) {
                    return;
                }
                if (!track.isRecArm() || slot.hasContent()) {
                    slot.launch(event == ButtonEvent.DOWN, false);
                    break;
                }
                this.model.recordNoteClip(track, slot);
                break;
            }
            case 1: {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                switch (this.clipFunction) {
                    case 0: {
                        int lengthInBeats = configuration.getNewClipLenghthInBeats(this.model.getTransport().getQuartersPerMeasure());
                        track.createClip(slot.getIndex(), lengthInBeats);
                        slot.select();
                        break block11;
                    }
                    case 1: {
                        slot.remove();
                        break block11;
                    }
                    case 2: {
                        slot.duplicate();
                        break block11;
                    }
                    case 3: {
                        slot.select();
                        ((ElectraOneControlSurface)this.surface).scheduleTask(() -> {
                            INoteClip clip = this.model.getCursorClip();
                            if (clip.doesExist()) {
                                clip.quantize((double)configuration.getQuantizeAmount() / 100.0);
                            }
                        }, 100L);
                        break block11;
                    }
                }
                track.stop(false);
                break;
            }
            case 2: {
                if (event != ButtonEvent.DOWN) {
                    return;
                }
                int numTracks = tb.getPageSize();
                int numScenes = sceneBank.getPageSize();
                int trackPosition = ((ITrack)tb.getItem(0)).getPosition() / numTracks;
                int scenePosition = sceneBank.getScrollPosition() / numScenes;
                int selX = trackPosition;
                int selY = scenePosition;
                int padsX = 5;
                int padsY = 6;
                int offsetX = selX / 5 * 5;
                int offsetY = selY / 6 * 6;
                sceneBank.scrollTo(offsetX * numScenes + index * 6);
                tb.scrollTo(offsetY * numTracks + (row - 1) * 5);
            }
        }
    }

    @Override
    public void updateDisplay() {
        this.pageCache.updateElement(2, 5, null, this.sessionUI == SessionUI.NAVIGATION ? ColorEx.SKY_BLUE : ColorEx.DARK_GRAY, Boolean.TRUE);
        this.pageCache.updateElement(3, 5, null, this.sessionUI == SessionUI.FUNCTIONS ? ColorEx.SKY_BLUE : ColorEx.DARK_GRAY, Boolean.TRUE);
        int columns = 5;
        int rows = 5;
        ITrackBank tb = this.model.getCurrentTrackBank();
        ISceneBank sceneBank = this.model.getSceneBank();
        if (this.sessionUI == SessionUI.NORMAL || this.sessionUI == SessionUI.FUNCTIONS) {
            for (int column = 0; column < 5; ++column) {
                IScene scene = (IScene)sceneBank.getItem(column);
                this.pageCache.updateGroupLabel(550 + column, (String)(scene.doesExist() ? scene.getPosition() + 1 + ": " + scene.getName() : ""));
                if (this.sessionUI == SessionUI.FUNCTIONS) {
                    this.pageCache.updateElement(0, column, FUNCTION_NAMES[column], this.clipFunction == column ? ColorEx.SKY_BLUE : ColorEx.DARK_GRAY, Boolean.TRUE);
                } else {
                    this.pageCache.updateElement(0, column, scene.getName(), scene.getColor(), scene.doesExist());
                }
                for (int row = 1; row < 6; ++row) {
                    String slotName;
                    ITrack t = (ITrack)tb.getItem(row - 1);
                    boolean isArmed = t.isRecArm();
                    ISlotBank slotBank = t.getSlotBank();
                    ISlot slot = (ISlot)slotBank.getItem(column);
                    boolean slotDoesExist = slot.doesExist();
                    String string = slotName = slotDoesExist && slot.hasContent() ? slot.getName() : "";
                    if (slotName.isBlank()) {
                        slotName = slotDoesExist ? "(" + t.getName() + ")" : "-";
                    }
                    this.pageCache.updateElement(row, column, slotName, this.getPadColor(slot, isArmed), slotDoesExist);
                }
            }
        } else {
            for (int column = 0; column < 5; ++column) {
                int trackSelection;
                this.pageCache.updateElement(0, column, NAVIGATION_NAMES[column], NAVIGATION_COLORS[column], Boolean.TRUE);
                int numTracks = tb.getPageSize();
                int numScenes = sceneBank.getPageSize();
                int sceneCount = sceneBank.getItemCount();
                int trackCount = tb.getItemCount();
                int maxScenePads = sceneCount / numScenes + (sceneCount % numScenes > 0 ? 1 : 0);
                int maxTrackPads = trackCount / numTracks + (trackCount % numTracks > 0 ? 1 : 0);
                int scenePosition = sceneBank.getScrollPosition();
                int trackPosition = ((ITrack)tb.getItem(0)).getPosition();
                int sceneSelection = scenePosition / numScenes + (scenePosition % numScenes > 0 ? 1 : 0);
                int selX = trackSelection = trackPosition / numTracks + (trackPosition % numTracks > 0 ? 1 : 0);
                int selY = sceneSelection;
                int padsX = 5;
                int padsY = 5;
                int offsetX = selX / 5 * 5;
                int offsetY = selY / 5 * 5;
                int maxX = maxTrackPads - offsetX;
                int maxY = maxScenePads - offsetY;
                selX -= offsetX;
                selY -= offsetY;
                ColorEx rowColor = column < maxX ? ColorEx.RED : ColorEx.BLACK;
                for (int y = 0; y < 5; ++y) {
                    ColorEx color;
                    boolean exists = y < maxY;
                    ColorEx colorEx = color = exists ? rowColor : ColorEx.BLACK;
                    if (selX == column && selY == y) {
                        color = ColorEx.ORANGE;
                    }
                    String n = exists && column < maxX ? String.format("Sc. %d - Tr. %d", scenePosition + 1 + 5 * column, trackPosition + 1 + 5 * y) : "-";
                    this.pageCache.updateElement(column + 1, y, n, color, Boolean.TRUE);
                }
            }
        }
        this.pageCache.updateColor(0, 5, this.masterTrack.getColor());
        this.pageCache.updateValue(0, 5, this.masterTrack.getVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.masterTrack.getVolumeStr()), 15));
        this.pageCache.updateValue(1, 5, 0, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getBeatText()), 15));
        this.pageCache.updateElement(1, 5, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getPositionText()), 15), null, null);
        this.pageCache.updateColor(4, 5, this.transport.isRecording() ? ElectraOneColorManager.RECORD_ON : ElectraOneColorManager.RECORD_OFF);
        this.pageCache.updateColor(5, 5, this.transport.isPlaying() ? ElectraOneColorManager.PLAY_ON : ElectraOneColorManager.PLAY_OFF);
        this.pageCache.flush();
    }

    public ColorEx getPadColor(ISlot slot, boolean isArmed) {
        if (slot.isSelected()) {
            return ColorEx.WHITE;
        }
        if (slot.isRecordingQueued()) {
            return ColorEx.DARK_RED;
        }
        if (slot.isRecording()) {
            return ColorEx.RED;
        }
        if (slot.isPlayingQueued()) {
            return ColorEx.DARK_GREEN;
        }
        if (slot.isPlaying()) {
            return ColorEx.GREEN;
        }
        if (slot.hasContent()) {
            return slot.getColor();
        }
        return slot.doesExist() && isArmed && ((ElectraOneConfiguration)((ElectraOneControlSurface)this.surface).getConfiguration()).isDrawRecordStripe() ? ColorEx.RED_WINE : ColorEx.BLACK;
    }

    private static enum SessionUI {
        NORMAL,
        FUNCTIONS,
        NAVIGATION;

    }
}

