/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.command.trigger;

import de.mossgrabers.controller.akai.fire.command.trigger.AbstractFireViewMultiSelectCommand;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.RecordQuantization;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class PlaySelectCommand
extends AbstractFireViewMultiSelectCommand {
    public PlaySelectCommand(IModel model, FireControlSurface surface) {
        super(model, surface, Views.PLAY, Views.PIANO);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        Views preferredView;
        if (event != ButtonEvent.UP) {
            return;
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
            this.model.getCursorClip().quantize(1.0);
            ((FireControlSurface)this.surface).getDisplay().notify("Quantize");
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        boolean doesExist = cursorTrack.doesExist();
        int position = cursorTrack.getPosition();
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.SESSION, Views.MIX}) && doesExist && (preferredView = viewManager.getPreferredView(position)) != null && this.viewIds.contains((Object)preferredView)) {
            viewManager.setActive(preferredView);
            return;
        }
        super.executeNormal(event);
        if (doesExist) {
            viewManager.setPreferredView(position, (Views)((Object)viewManager.getActiveID()));
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            return;
        }
        RecordQuantization[] values = RecordQuantization.values();
        RecordQuantization recordQuantization = cursorTrack.getRecordQuantizationGrid();
        int index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (recordQuantization != values[i]) continue;
            index = i + 1;
            if (index < values.length) break;
            index = 0;
            break;
        }
        cursorTrack.setRecordQuantizationGrid(values[index]);
        ((FireControlSurface)this.surface).getDisplay().notify("Rec. Quant.: " + values[index].getName());
    }
}

