/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.controller;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import java.util.Arrays;

public class APCControlSurface
extends AbstractControlSurface<APCConfiguration> {
    public static final int APC_BUTTON_RECORD_ARM = 48;
    public static final int APC_BUTTON_SOLO = 49;
    public static final int APC_BUTTON_ACTIVATOR = 50;
    public static final int APC_BUTTON_TRACK_SELECTION = 51;
    public static final int APC_BUTTON_CLIP_STOP = 52;
    public static final int APC_BUTTON_CLIP_LAUNCH_1 = 53;
    public static final int APC_BUTTON_CLIP_LAUNCH_2 = 54;
    public static final int APC_BUTTON_CLIP_LAUNCH_3 = 55;
    public static final int APC_BUTTON_CLIP_LAUNCH_4 = 56;
    public static final int APC_BUTTON_CLIP_LAUNCH_5 = 57;
    public static final int APC_BUTTON_CLIP_TRACK = 58;
    public static final int APC_BUTTON_DEVICE_ON_OFF = 59;
    public static final int APC_BUTTON_DEVICE_LEFT = 60;
    public static final int APC_BUTTON_DEVICE_RIGHT = 61;
    public static final int APC_BUTTON_DETAIL_VIEW = 62;
    public static final int APC_BUTTON_REC_QUANT = 63;
    public static final int APC_BUTTON_MIDI_OVERDUB = 64;
    public static final int APC_BUTTON_METRONOME = 65;
    public static final int APC_BUTTON_A_B = 66;
    public static final int APC_BUTTON_MASTER = 80;
    public static final int APC_BUTTON_STOP_ALL_CLIPS = 81;
    public static final int APC_BUTTON_SCENE_LAUNCH_1 = 82;
    public static final int APC_BUTTON_SCENE_LAUNCH_2 = 83;
    public static final int APC_BUTTON_SCENE_LAUNCH_3 = 84;
    public static final int APC_BUTTON_SCENE_LAUNCH_4 = 85;
    public static final int APC_BUTTON_SCENE_LAUNCH_5 = 86;
    public static final int APC_BUTTON_PAN = 87;
    public static final int APC_BUTTON_SEND_A = 88;
    public static final int APC_BUTTON_SEND_B = 89;
    public static final int APC_BUTTON_SEND_C = 90;
    public static final int APC_BUTTON_PLAY = 91;
    public static final int APC_BUTTON_STOP = 92;
    public static final int APC_BUTTON_RECORD = 93;
    public static final int APC_BUTTON_UP = 94;
    public static final int APC_BUTTON_DOWN = 95;
    public static final int APC_BUTTON_RIGHT = 96;
    public static final int APC_BUTTON_LEFT = 97;
    public static final int APC_BUTTON_SHIFT = 98;
    public static final int APC_BUTTON_TAP_TEMPO = 99;
    public static final int APC_BUTTON_NUDGE_PLUS = 100;
    public static final int APC_BUTTON_NUDGE_MINUS = 101;
    public static final int APC_BUTTON_SESSION = 102;
    public static final int APC_BUTTON_BANK = 103;
    public static final int APC_KNOB_TRACK_LEVEL = 7;
    public static final int APC_KNOB_TEMPO = 13;
    public static final int APC_KNOB_MASTER_LEVEL = 14;
    public static final int APC_KNOB_CROSSFADER = 15;
    public static final int APC_KNOB_DEVICE_KNOB_1 = 16;
    public static final int APC_KNOB_DEVICE_KNOB_2 = 17;
    public static final int APC_KNOB_DEVICE_KNOB_3 = 18;
    public static final int APC_KNOB_DEVICE_KNOB_4 = 19;
    public static final int APC_KNOB_DEVICE_KNOB_5 = 20;
    public static final int APC_KNOB_DEVICE_KNOB_6 = 21;
    public static final int APC_KNOB_DEVICE_KNOB_7 = 22;
    public static final int APC_KNOB_DEVICE_KNOB_8 = 23;
    public static final int APC_KNOB_DEVICE_KNOB_LED_1 = 24;
    public static final int APC_KNOB_DEVICE_KNOB_LED_2 = 25;
    public static final int APC_KNOB_DEVICE_KNOB_LED_3 = 26;
    public static final int APC_KNOB_DEVICE_KNOB_LED_4 = 27;
    public static final int APC_KNOB_DEVICE_KNOB_LED_5 = 28;
    public static final int APC_KNOB_DEVICE_KNOB_LED_6 = 29;
    public static final int APC_KNOB_DEVICE_KNOB_LED_7 = 30;
    public static final int APC_KNOB_DEVICE_KNOB_LED_8 = 31;
    public static final int APC_KNOB_CUE_LEVEL = 47;
    public static final int APC_KNOB_TRACK_KNOB_1 = 48;
    public static final int APC_KNOB_TRACK_KNOB_2 = 49;
    public static final int APC_KNOB_TRACK_KNOB_3 = 50;
    public static final int APC_KNOB_TRACK_KNOB_4 = 51;
    public static final int APC_KNOB_TRACK_KNOB_5 = 52;
    public static final int APC_KNOB_TRACK_KNOB_6 = 53;
    public static final int APC_KNOB_TRACK_KNOB_7 = 54;
    public static final int APC_KNOB_TRACK_KNOB_8 = 55;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_1 = 56;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_2 = 57;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_3 = 58;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_4 = 59;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_5 = 60;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_6 = 61;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_7 = 62;
    public static final int APC_KNOB_TRACK_KNOB_LED_MODE_8 = 63;
    public static final int APC_FOOTSWITCH_1 = 64;
    public static final int APC_FOOTSWITCH_2 = 67;
    private static final String ID_APC_40 = "73";
    private static final String ID_APC_40_MKII = "29";
    public static final int LED_MODE_SINGLE = 1;
    public static final int LED_MODE_VOLUME = 2;
    public static final int LED_MODE_PAN = 3;
    private final boolean isMkII;
    private final int[] knobCache = new int[128];

    public APCControlSurface(IHost host, ColorManager colorManager, APCConfiguration configuration, IMidiOutput output, IMidiInput input, boolean isMkII) {
        super(host, configuration, colorManager, output, input, new APCPadGrid(colorManager, output, isMkII), 800.0, isMkII ? 480.0 : 640.0);
        this.isMkII = isMkII;
        Arrays.fill(this.knobCache, -1);
        this.output.sendSysex("F0 47 7F " + (isMkII ? ID_APC_40_MKII : ID_APC_40) + " 60 00 04 41 08 02 01 F7");
    }

    public boolean isMkII() {
        return this.isMkII;
    }

    public void setLED(int knob, int value) {
        if (this.knobCache[knob] == value) {
            return;
        }
        this.knobCache[knob] = value;
        this.scheduleTask(() -> {
            if (this.knobCache[knob] == value) {
                this.output.sendCC(knob, value);
            }
        }, 100L);
    }
}

