/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.parameterprovider;

import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.VolumeLayerOrDrumPadParameterProvider;
import java.util.Optional;

public class PushVolumeLayerOrDrumPadParameterProvider
extends VolumeLayerOrDrumPadParameterProvider
implements IItemSelectionObserver {
    public PushVolumeLayerOrDrumPadParameterProvider(ISpecificDevice device) {
        super(device);
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        this.bank.addSelectionObserver(this);
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        super.removeParametersObserver(observer);
        if (!this.hasObservers()) {
            this.bank.removeSelectionObserver(this);
        }
    }

    @Override
    public IParameter get(int index) {
        Optional selectedDrumPad;
        if (!this.device.hasLayers()) {
            return EmptyParameter.INSTANCE;
        }
        int offset = 0;
        if (this.device.hasDrumPads() && (selectedDrumPad = this.bank.getSelectedItem()).isPresent() && ((IChannel)selectedDrumPad.get()).getIndex() > 7) {
            offset = 8;
        }
        return super.get(offset + index);
    }

    @Override
    public void call(int index, boolean isSelected) {
        this.notifyParametersObservers();
    }
}

