/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractTrackMode
extends BaseMode<ITrack> {
    protected final List<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();
    protected final PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();

    protected AbstractTrackMode(String name, PushControlSurface surface, IModel model) {
        super(name, surface, model, model.getCurrentTrackBank());
        model.addTrackBankObserver(x$0 -> this.switchBanks(x$0));
        for (int i = 0; i < 8; ++i) {
            this.menu.add(new Pair<String, Boolean>(" ", Boolean.FALSE));
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        IParameter parameter = this.getParameterProvider().get(index);
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            parameter.resetValue();
        }
        parameter.touchValue(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        ITrack track = (ITrack)tb.getItem(index);
        if (event == ButtonEvent.UP) {
            if (((PushControlSurface)this.surface).isPressed(ButtonID.DUPLICATE)) {
                ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DUPLICATE);
                track.duplicate();
                return;
            }
            if (((PushControlSurface)this.surface).isPressed(ButtonID.DELETE)) {
                ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
                track.remove();
                return;
            }
            if (((PushControlSurface)this.surface).isPressed(ButtonID.STOP_CLIP)) {
                ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.STOP_CLIP);
                track.stop(true);
                return;
            }
            if (((PushControlSurface)this.surface).isPressed(ButtonID.RECORD)) {
                ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.RECORD);
                track.toggleRecArm();
                return;
            }
            if (((PushControlSurface)this.surface).isSelectPressed()) {
                ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
                track.toggleMultiSelect();
                return;
            }
            if (!track.isSelected()) {
                track.select();
                return;
            }
            if (track.isGroup()) {
                if (((PushControlSurface)this.surface).isShiftPressed() || this.configuration.isTrackNavigationFlat()) {
                    track.toggleGroupExpanded();
                } else {
                    track.setGroupExpanded(true);
                    track.enter();
                }
            } else {
                ((PushControlSurface)this.surface).getButton(ButtonID.DEVICE).trigger(ButtonEvent.DOWN);
            }
            return;
        }
        this.model.getTrackBank().selectParent();
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.get(ButtonID.ROW1_1, index));
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        ITrack track = (ITrack)tb.getItem(index);
        if (this.configuration.isMuteState(((PushControlSurface)this.surface).isLongPressed(ButtonID.MUTE))) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.MUTE);
            track.toggleMute();
            return;
        }
        if (this.configuration.isSoloState(((PushControlSurface)this.surface).isLongPressed(ButtonID.SOLO))) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SOLO);
            track.toggleSolo();
            return;
        }
        if (this.configuration.isClipStopState(((PushControlSurface)this.surface).isLongPressed(ButtonID.STOP_CLIP))) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.STOP_CLIP);
            track.stop(((PushControlSurface)this.surface).isShiftPressed());
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: {
                if (modeManager.isActive(new Modes[]{Modes.VOLUME})) {
                    modeManager.setActive(Modes.TRACK);
                    break;
                }
                modeManager.setActive(Modes.VOLUME);
                break;
            }
            case 1: {
                if (modeManager.isActive(new Modes[]{Modes.PAN})) {
                    modeManager.setActive(Modes.TRACK);
                    break;
                }
                modeManager.setActive(Modes.PAN);
                break;
            }
            case 2: {
                if (modeManager.isActive(new Modes[]{Modes.CROSSFADER})) {
                    modeManager.setActive(Modes.TRACK);
                    break;
                }
                modeManager.setActive(Modes.CROSSFADER);
                break;
            }
            case 3: {
                boolean isShift = ((PushControlSurface)this.surface).isShiftPressed();
                for (int i = 0; i < tb.getPageSize(); ++i) {
                    ISendBank sendBank = ((ITrack)tb.getItem(i)).getSendBank();
                    if (isShift) {
                        if (sendBank.canScrollPageBackwards()) {
                            sendBank.selectPreviousPage();
                            continue;
                        }
                        sendBank.scrollTo(sendBank.getItemCount() / 4 * 4);
                        continue;
                    }
                    if (sendBank.canScrollPageForwards()) {
                        sendBank.selectNextPage();
                        continue;
                    }
                    sendBank.scrollTo(0);
                }
                this.bindControls();
                break;
            }
            case 7: {
                if (this.lastSendIsAccessible()) {
                    this.handleSendEffect(3);
                    break;
                }
                this.model.getTrackBank().selectParent();
                break;
            }
            default: {
                this.handleSendEffect(index - 4);
            }
        }
        this.configuration.setMixerMode((Modes)((Object)modeManager.getActiveID()));
    }

    @Override
    public void selectPreviousItemPage() {
        switch (((PushControlSurface)this.surface).isShiftPressed() ? this.configuration.getCursorKeysTrackShiftedOption() : this.configuration.getCursorKeysTrackOption()) {
            case 0: {
                super.selectPreviousItemPage();
                break;
            }
            case 1: {
                this.model.getCurrentTrackBank().scrollBackwards();
                break;
            }
            case 2: {
                this.model.getCursorTrack().swapWithPrevious();
            }
        }
    }

    @Override
    public void selectNextItemPage() {
        switch (((PushControlSurface)this.surface).isShiftPressed() ? this.configuration.getCursorKeysTrackShiftedOption() : this.configuration.getCursorKeysTrackOption()) {
            case 0: {
                super.selectNextItemPage();
                break;
            }
            case 1: {
                this.model.getCurrentTrackBank().scrollForwards();
                break;
            }
            case 2: {
                this.model.getCursorTrack().swapWithNext();
            }
        }
    }

    @Override
    public boolean hasPreviousItem() {
        switch (this.configuration.getCursorKeysTrackShiftedOption()) {
            case 0: {
                return super.hasPreviousItemPage();
            }
        }
        return super.hasPreviousItem();
    }

    @Override
    public boolean hasNextItem() {
        switch (this.configuration.getCursorKeysTrackShiftedOption()) {
            case 0: {
                return super.hasNextItemPage();
            }
        }
        return super.hasNextItem();
    }

    @Override
    public boolean hasPreviousItemPage() {
        switch (this.configuration.getCursorKeysTrackOption()) {
            case 0: {
                return super.hasPreviousItemPage();
            }
        }
        return super.hasPreviousItem();
    }

    @Override
    public boolean hasNextItemPage() {
        switch (this.configuration.getCursorKeysTrackOption()) {
            case 0: {
                return super.hasNextItemPage();
            }
        }
        return super.hasNextItem();
    }

    protected void handleSendEffect(int sendIndex) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        if (tb == null || !tb.canEditSend(sendIndex)) {
            return;
        }
        Modes si = Modes.get(Modes.SEND1, sendIndex);
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        modeManager.setActive(modeManager.isActive(new Modes[]{si}) ? Modes.TRACK : si);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        ITrackBank tb = this.model.getCurrentTrackBank();
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            boolean isSel;
            ITrack track = (ITrack)tb.getItem(index);
            if (!track.doesExist() || !track.isActivated()) {
                return this.colorManager.getColorIndex("PUSH_BLACK");
            }
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            int selIndex = cursorTrack.doesExist() ? cursorTrack.getIndex() : -1;
            boolean bl = isSel = track.getIndex() == selIndex;
            if (track.isRecArm()) {
                return this.colorManager.getColorIndex(isSel ? "PUSH_RED_HI" : "PUSH_RED_LO");
            }
            return this.colorManager.getColorIndex(isSel ? "PUSH_ORANGE_HI" : "PUSH_YELLOW_LO");
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            ITrack track = (ITrack)tb.getItem(index);
            if (this.isPushModern) {
                if (config.isSoloState(((PushControlSurface)this.surface).isLongPressed(ButtonID.SOLO))) {
                    return track.doesExist() && track.isSolo() ? 13 : 0;
                }
                if (config.isMuteState(((PushControlSurface)this.surface).isLongPressed(ButtonID.MUTE))) {
                    return track.doesExist() && track.isMute() ? 11 : 0;
                }
                if (config.isClipStopState(((PushControlSurface)this.surface).isLongPressed(ButtonID.STOP_CLIP))) {
                    return track.doesExist() && track.isPlaying() ? 5 : 0;
                }
                ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
                switch (index) {
                    case 0: {
                        return modeManager.isActive(new Modes[]{Modes.VOLUME}) ? 3 : 0;
                    }
                    case 1: {
                        return modeManager.isActive(new Modes[]{Modes.PAN}) ? 3 : 0;
                    }
                    case 2: {
                        return modeManager.isActive(new Modes[]{Modes.CROSSFADER}) ? 3 : 0;
                    }
                    case 4: {
                        Modes sendMode1 = Modes.SEND1;
                        return modeManager.isActive(new Modes[]{sendMode1}) ? 3 : 0;
                    }
                    case 5: {
                        Modes sendMode2 = Modes.SEND2;
                        return modeManager.isActive(new Modes[]{sendMode2}) ? 3 : 0;
                    }
                    case 6: {
                        Modes sendMode3 = Modes.SEND3;
                        return modeManager.isActive(new Modes[]{sendMode3}) ? 3 : 0;
                    }
                    case 7: {
                        if (this.lastSendIsAccessible()) {
                            Modes sendMode4 = Modes.SEND4;
                            return modeManager.isActive(new Modes[]{sendMode4}) ? 3 : 0;
                        }
                        return tb.hasParent() ? 3 : 0;
                    }
                }
                return 0;
            }
            if (!track.doesExist()) {
                return 0;
            }
            switch (config.getLockState()) {
                case MUTE: {
                    return track.isMute() ? 0 : 13;
                }
                case SOLO: {
                    return track.isSolo() ? 45 : 1;
                }
                case CLIP_STOP: {
                    return 4;
                }
            }
        }
        return super.getButtonColor(buttonID);
    }

    protected void drawRow4(ITextDisplay d) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selTrack = tb.getSelectedItem();
        int selIndex = selTrack.isEmpty() ? -1 : ((ITrack)selTrack.get()).getIndex();
        for (int i = 0; i < 8; ++i) {
            boolean isSel = i == selIndex;
            ITrack t = (ITrack)tb.getItem(i);
            Object trackName = t.getName();
            if (t.doesExist() && t.isGroup()) {
                trackName = (t.isGroupExpanded() ? Push1Display.THREE_ROWS : Push1Display.FOLDER) + (String)trackName;
            }
            String n = StringUtils.shortenAndFixASCII((String)trackName, isSel ? 7 : 8);
            d.setCell(3, i, (String)(isSel ? Push1Display.SELECT_ARROW + n : n));
        }
    }

    protected void updateChannelDisplay(IGraphicDisplay display, int selectedMenu, boolean isVolume, boolean isPan) {
        this.updateMenuItems(selectedMenu);
        IValueChanger valueChanger = this.model.getValueChanger();
        ITrackBank tb = this.model.getCurrentTrackBank();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            Pair<String, Boolean> pair = this.menu.get(i);
            String topMenu = pair.getKey();
            boolean isTopMenuOn = pair.getValue();
            int crossfadeMode = this.getCrossfadeModeAsNumber(t);
            boolean enableVUMeters = config.isEnableVUMeters();
            int vuR = valueChanger.toDisplayValue(enableVUMeters ? t.getVuRight() : 0);
            int vuL = valueChanger.toDisplayValue(enableVUMeters ? t.getVuLeft() : 0);
            display.addChannelElement(selectedMenu, topMenu, isTopMenuOn, t.doesExist() ? t.getName(12) : "", this.updateType(t), t.getColor(), t.isSelected(), valueChanger.toDisplayValue(t.getVolume()), valueChanger.toDisplayValue(t.getModulatedVolume()), isVolume && this.isKnobTouched(i) ? t.getVolumeStr(8) : "", valueChanger.toDisplayValue(t.getPan()), valueChanger.toDisplayValue(t.getModulatedPan()), isPan && this.isKnobTouched(i) ? t.getPanStr(8) : "", vuL, vuR, t.isMute(), t.isSolo(), t.isRecArm(), t.isActivated(), crossfadeMode, t.isSelected() && cursorTrack.isPinned());
        }
    }

    protected void updateMenuItems(int selectedMenu) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (config.isMuteState(((PushControlSurface)this.surface).isLongPressed(ButtonID.MUTE))) {
            this.updateMuteMenu();
        } else if (config.isSoloState(((PushControlSurface)this.surface).isLongPressed(ButtonID.SOLO))) {
            this.updateSoloMenu();
        } else if (config.isClipStopState(((PushControlSurface)this.surface).isLongPressed(ButtonID.STOP_CLIP))) {
            this.updateStopMenu();
        } else {
            this.updateTrackMenu(selectedMenu);
        }
    }

    protected void updateStopMenu() {
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t;
            this.menu.get(i).set((t = (ITrack)tb.getItem(i)).doesExist() ? "Stop Clip" : "", t.isPlaying());
        }
    }

    protected void updateMuteMenu() {
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t;
            this.menu.get(i).set((t = (ITrack)tb.getItem(i)).doesExist() ? "Mute" : "", t.isMute());
        }
    }

    protected void updateSoloMenu() {
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t;
            this.menu.get(i).set((t = (ITrack)tb.getItem(i)).doesExist() ? "Solo" : "", t.isSolo());
        }
    }

    protected void updateTrackMenu(int selectedMenu) {
        boolean isUpAvailable;
        this.menu.get(0).set("Volume", selectedMenu - 1 == 0);
        this.menu.get(1).set("Pan", selectedMenu - 1 == 1);
        this.menu.get(2).set(this.model.getHost().supports(Capability.HAS_CROSSFADER) ? "Crossfader" : " ", selectedMenu - 1 == 2);
        ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
        Optional selectedItem = currentTrackBank.getSelectedItem();
        ISendBank sendBank = (selectedItem.isPresent() ? (ITrack)selectedItem.get() : (ITrack)currentTrackBank.getItem(0)).getSendBank();
        int start = Math.max(0, sendBank.getScrollPosition()) + 1;
        this.menu.get(3).set(String.format("Sends %d-%d", start, start + 3), Boolean.FALSE);
        ITrackBank tb = currentTrackBank;
        for (int i = 0; i < 4; ++i) {
            String sendName = tb.getEditSendName(i);
            boolean exists = !sendName.isEmpty();
            this.menu.get(4 + i).set(exists ? sendName : " ", exists && 4 + i == selectedMenu - 1);
        }
        if (this.lastSendIsAccessible()) {
            return;
        }
        this.menu.get(7).set((isUpAvailable = tb.hasParent()) ? "Up" : " ", isUpAvailable);
    }

    private boolean lastSendIsAccessible() {
        return ((PushControlSurface)this.surface).isShiftPressed() || !this.model.getCurrentTrackBank().hasParent() || this.isKnobTouched(7);
    }

    protected int getCrossfadeModeAsNumber(ITrack track) {
        if (this.model.getHost().supports(Capability.HAS_CROSSFADER)) {
            return (int)Math.round(this.model.getValueChanger().toNormalizedValue(track.getCrossfadeParameter().getValue()) * 2.0);
        }
        return -1;
    }

    protected ChannelType updateType(ITrack track) {
        ChannelType type = track.getType();
        return type == ChannelType.GROUP && track.isGroupExpanded() ? ChannelType.GROUP_OPEN : type;
    }
}

