/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.dialog;

import de.mossgrabers.reaper.framework.configuration.ActionSettingImpl;
import de.mossgrabers.reaper.framework.configuration.GlobalSettingsUI;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.framework.midi.Midi;
import de.mossgrabers.reaper.framework.midi.MissingMidiDevice;
import de.mossgrabers.reaper.ui.dialog.BasicDialog;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.widget.BoxPanel;
import de.mossgrabers.reaper.ui.widget.Functions;
import de.mossgrabers.reaper.ui.widget.JComboBoxX;
import de.mossgrabers.reaper.ui.widget.TitledSeparator;
import de.mossgrabers.reaper.ui.widget.TwoColsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ConfigurationDialog
extends BasicDialog {
    private static final long serialVersionUID = -495747813993365661L;
    private static final int MIN_HEIGHT = 600;
    private List<JComboBoxX<MidiDevice>> midiInputBoxes;
    private List<JComboBoxX<MidiDevice>> midiOutputBoxes;
    private final transient LogModel model;
    private final transient GlobalSettingsUI settings;

    public ConfigurationDialog(LogModel model, Window owner, GlobalSettingsUI settings) {
        this(model, owner, settings, true);
    }

    public ConfigurationDialog(LogModel model, Window owner, GlobalSettingsUI settings, boolean isModal) {
        super((JFrame)owner, "Configuration", isModal, true);
        this.setMinimumSize(new Dimension(400, 600));
        this.setSize(400, 600);
        this.model = model;
        this.settings = settings;
        this.basicInit();
    }

    public void setAction(String actionID) {
        for (IfxSetting s : this.settings.getSettings()) {
            ActionSettingImpl asi;
            if (!(s instanceof ActionSettingImpl) || !(asi = (ActionSettingImpl)s).isSelectionActive()) continue;
            asi.set(actionID);
            this.toFront();
        }
    }

    @Override
    protected Container init() {
        JPanel contentPane = new JPanel(new BorderLayout());
        TwoColsPanel mainColumn = new TwoColsPanel(true);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)mainColumn, "North");
        JScrollPane scrollPane = new JScrollPane(wrapper);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.getVerticalScrollBar().setUnitIncrement(40);
        contentPane.add((Component)scrollPane, "Center");
        this.midiInputBoxes = this.settings.createMidiInputWidgets();
        this.midiOutputBoxes = this.settings.createMidiOutputWidgets();
        if (!this.midiInputBoxes.isEmpty() || !this.midiOutputBoxes.isEmpty()) {
            int i;
            mainColumn.addComponent(new TitledSeparator("Midi Ports"), 12);
            for (i = 0; i < this.midiInputBoxes.size(); ++i) {
                mainColumn.addComponent(this.midiInputBoxes.get(i), new JLabel("Midi Input " + (i + 1)), null, 12);
            }
            for (i = 0; i < this.midiOutputBoxes.size(); ++i) {
                mainColumn.addComponent(this.midiOutputBoxes.get(i), new JLabel("Midi Output " + (i + 1)), null, 12);
            }
            JButton rescanButton = new JButton("Rescan Midi Devices");
            rescanButton.addActionListener(event -> this.updateMidiDevices());
            mainColumn.addComponent(rescanButton, 12);
            this.fillAndSetMidiDevices();
        }
        String category = null;
        for (IfxSetting s : this.settings.getSettings()) {
            String cat = s.getCategory();
            if (category == null || !category.equals(cat)) {
                category = s.getCategory();
                mainColumn.addComponent(new TitledSeparator(category), 12);
            }
            JLabel label = s.getLabelWidget();
            JComponent widget = s.getWidget();
            mainColumn.addComponent(widget, label, null, 12);
        }
        BoxPanel buttons = new BoxPanel(0, true);
        buttons.createSpace(-1);
        this.setButtons(null, buttons.createButton(Functions.getIcon("Confirm"), "Close", null, 0));
        contentPane.add((Component)buttons, "South");
        return contentPane;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        double maxHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 200.0;
        if ((double)dim.height > maxHeight) {
            dim.height = (int)maxHeight;
        }
        return dim;
    }

    void updateMidiDevices() {
        new Thread(this::delayedUpdateMidiDevices).start();
    }

    void delayedUpdateMidiDevices() {
        try {
            Midi.readDeviceMetadata();
            this.settings.initMIDI();
            this.fillAndSetMidiDevices();
        }
        catch (MidiUnavailableException ex) {
            this.model.error("Could not update MIDI devices.", ex);
        }
    }

    private void fillAndSetMidiDevices() {
        Collection<MidiDevice> inputDevices = Midi.getInputDevices();
        for (int i = 0; i < this.midiInputBoxes.size(); ++i) {
            ArrayList<MidiDevice> devices = new ArrayList<MidiDevice>(inputDevices);
            JComboBoxX<MidiDevice> deviceBox = this.midiInputBoxes.get(i);
            MidiDevice selectedDevice = this.settings.getSelectedMidiInput(i);
            if (selectedDevice instanceof MissingMidiDevice) {
                devices.add(0, selectedDevice);
            }
            deviceBox.setAll(devices);
            deviceBox.setSelectedItem(selectedDevice);
        }
        Collection<MidiDevice> outputDevices = Midi.getOutputDevices();
        for (int i = 0; i < this.midiOutputBoxes.size(); ++i) {
            ArrayList<MidiDevice> devices = new ArrayList<MidiDevice>(outputDevices);
            JComboBoxX<MidiDevice> deviceBox = this.midiOutputBoxes.get(i);
            MidiDevice selectedDevice = this.settings.getSelectedMidiOutput(i);
            if (selectedDevice instanceof MissingMidiDevice) {
                devices.add(0, selectedDevice);
            }
            deviceBox.setAll(devices);
            deviceBox.setSelectedItem(selectedDevice);
        }
    }
}

