/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class RenamedMidiDevice
implements MidiDevice {
    private final MidiDevice device;
    private final MidiDevice.Info info;

    public RenamedMidiDevice(String name, MidiDevice device) {
        this.device = device;
        this.info = new RenamedInfo(name, device.getDeviceInfo());
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    @Override
    public void open() throws MidiUnavailableException {
        this.device.open();
    }

    @Override
    public void close() {
        this.device.close();
    }

    @Override
    public boolean isOpen() {
        return this.device.isOpen();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.device.getMicrosecondPosition();
    }

    @Override
    public int getMaxReceivers() {
        return this.device.getMaxReceivers();
    }

    @Override
    public int getMaxTransmitters() {
        return this.device.getMaxTransmitters();
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return this.device.getReceiver();
    }

    @Override
    public List<Receiver> getReceivers() {
        return this.device.getReceivers();
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return this.device.getTransmitter();
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return this.device.getTransmitters();
    }

    public static class RenamedInfo
    extends MidiDevice.Info {
        protected RenamedInfo(String name, MidiDevice.Info info) {
            super(name, info.getVendor(), info.getDescription(), info.getVersion());
        }
    }
}

