/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.communication.Processor;
import java.util.List;

public class NoteRepeatImpl
implements INoteRepeat {
    public static final List<ArpeggiatorMode> ARP_MODES = List.of(ArpeggiatorMode.DOWN, ArpeggiatorMode.UP, ArpeggiatorMode.DOWN_UP, ArpeggiatorMode.UP_DOWN);
    private final MessageSender sender;
    private boolean isNoteRepeat = false;
    private double noteRepeatPeriod;
    private double noteLength;
    private boolean usePressure;
    private ArpeggiatorMode mode;

    public NoteRepeatImpl(MessageSender sender) {
        this.sender = sender;
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public boolean isActive() {
        return this.isNoteRepeat;
    }

    @Override
    public void toggleActive() {
        this.sender.processBooleanArg(Processor.NOTEREPEAT, "active", !this.isNoteRepeat);
    }

    @Override
    public void setActive(boolean active) {
        if (this.isNoteRepeat != active) {
            this.isNoteRepeat = active;
            this.sender.processBooleanArg(Processor.NOTEREPEAT, "active", active);
        }
    }

    @Override
    public void setPeriod(double period) {
        this.sender.processDoubleArg(Processor.NOTEREPEAT, "rate", 1.0 / period);
    }

    @Override
    public double getPeriod() {
        return this.noteRepeatPeriod;
    }

    @Override
    public void setNoteLength(double length) {
        this.sender.processDoubleArg(Processor.NOTEREPEAT, "notelength", length);
    }

    @Override
    public double getNoteLength() {
        return this.noteLength;
    }

    @Override
    public boolean isShuffle() {
        return false;
    }

    @Override
    public void toggleShuffle() {
    }

    @Override
    public boolean usePressure() {
        return this.usePressure;
    }

    @Override
    public void toggleUsePressure() {
        this.sender.processBooleanArg(Processor.NOTEREPEAT, "velocity", !this.usePressure);
    }

    @Override
    public int getOctaves() {
        return 0;
    }

    @Override
    public void setOctaves(int octaves) {
    }

    @Override
    public void setMode(ArpeggiatorMode mode) {
        int index = ARP_MODES.indexOf((Object)mode);
        if (index >= 0) {
            this.sender.processIntArg(Processor.NOTEREPEAT, "mode", index);
        }
    }

    @Override
    public ArpeggiatorMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isFreeRunning() {
        return false;
    }

    @Override
    public void toggleIsFreeRunning() {
    }

    @Override
    public void toggleLatchActive() {
    }

    @Override
    public boolean isLatchActive() {
        return false;
    }

    @Override
    public void setLatchActive(boolean active) {
    }

    public void setInternalPeriod(double period) {
        this.noteRepeatPeriod = period;
    }

    public void setInternalNoteLength(double length) {
        this.noteLength = length;
    }

    public void setInternalUsePressure(boolean usePressure) {
        this.usePressure = usePressure;
    }

    public void setInternalMode(int modeIndex) {
        this.mode = ARP_MODES.get(modeIndex >= 0 && modeIndex < ARP_MODES.size() ? modeIndex : 0);
    }
}

