/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.midi.AbstractNoteInput;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.framework.midi.NoteRepeatImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class NoteInputImpl
extends AbstractNoteInput {
    private Integer[] keyTranslationTable;
    private Integer[] velocityTranslationTable;
    private final Set<String> filters = new HashSet<String>();

    public NoteInputImpl(MessageSender sender, String ... filters) {
        if (filters.length == 0) {
            this.filters.add("90");
            this.filters.add("80");
            this.filters.add("B001");
            this.filters.add("B00B");
            this.filters.add("B040");
            this.filters.add("E0");
            this.filters.add("D0");
            this.filters.add("A0");
        } else {
            for (String filter : filters) {
                String trim = filter.replace('?', ' ').trim();
                ArrayList<String> replaced = new ArrayList<String>(1);
                replaced.add(trim);
                while (((String)replaced.get(0)).contains(" ")) {
                    ArrayList<String> replaced2 = new ArrayList<String>();
                    for (String f : replaced) {
                        for (int i = 0; i <= 15; ++i) {
                            replaced2.add(f.replaceFirst(" ", Integer.toHexString(i).toUpperCase(Locale.US)));
                        }
                    }
                    replaced = replaced2;
                }
                this.filters.addAll(replaced);
            }
        }
        this.noteRepeat = new NoteRepeatImpl(sender);
    }

    @Override
    public void setKeyTranslationTable(Integer[] table) {
        this.keyTranslationTable = table;
    }

    @Override
    public void setVelocityTranslationTable(Integer[] table) {
        this.velocityTranslationTable = table;
    }

    @Override
    public void enableMPE(boolean enable) {
        this.isMPEEnabled = enable;
    }

    @Override
    public void setMPEPitchBendSensitivity(int pitchBendRange) {
        this.mpePitchBendSensitivity = pitchBendRange;
    }

    public boolean acceptFilter(int status, int data1) {
        String code = String.format("%02X%02X", status, data1);
        for (String filter : this.filters) {
            if (!code.startsWith(filter)) continue;
            return true;
        }
        return false;
    }

    public int translateKey(int key) {
        return this.keyTranslationTable == null ? key : this.keyTranslationTable[key];
    }

    public int translateVelocity(int velocity) {
        return this.velocityTranslationTable == null ? velocity : this.velocityTranslationTable[velocity];
    }
}

