/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.AbstractHwButton;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import de.mossgrabers.reaper.framework.hardware.HwControlLayout;
import de.mossgrabers.reaper.framework.hardware.HwLightImpl;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;
import de.mossgrabers.reaper.framework.midi.MidiInputImpl;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class HwButtonImpl
extends AbstractHwButton
implements IReaperHwControl {
    private final HwControlLayout layout;
    private MidiInputImpl inputImpl;
    private int control;
    private int value;
    private double currentY = -1.0;

    public HwButtonImpl(String id, IHost host, String label) {
        super(host, label);
        this.layout = new HwControlLayout(id);
    }

    @Override
    public void bind(TriggerCommand command) {
        this.command = command;
    }

    @Override
    public void bind(IMidiInput input, BindType type, int channel, int control) {
        this.bind(input, type, channel, control, -1);
    }

    @Override
    public void bind(IMidiInput input, BindType type, int channel, int control, int value) {
        this.inputImpl = (MidiInputImpl)input;
        this.type = type;
        this.channel = channel;
        this.control = control;
        this.value = value;
        if (value < 0) {
            input.bind(this, type, channel, control);
        } else {
            input.bind(this, type, channel, control, value);
        }
    }

    @Override
    public void unbind() {
        if (this.input != null) {
            this.input.unbind(this);
        }
    }

    @Override
    public void rebind() {
        if (this.input == null) {
            return;
        }
        this.unbind();
        if (this.value < 0) {
            this.input.bind(this, this.type, this.channel, this.control);
        } else {
            this.input.bind(this, this.type, this.channel, this.control, this.value);
        }
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.layout.setBounds(x, y, width, height);
        if (this.light != null) {
            this.light.setBounds(x, y, width, height);
        }
    }

    @Override
    public void update() {
        if (this.light != null) {
            this.light.update();
        }
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        ColorEx textColor = ColorEx.WHITE;
        if (this.light != null) {
            HwLightImpl hwLightImpl = (HwLightImpl)this.light;
            hwLightImpl.draw(gc, scale);
            ColorEx colorState = hwLightImpl.getColorState();
            if (colorState != null) {
                textColor = ColorEx.calcContrastColor(colorState);
            }
        }
        if (this.label != null) {
            Bounds bounds = this.layout.getBounds();
            if (bounds == null) {
                return;
            }
            double width = bounds.width() * scale;
            double height = bounds.height() * scale;
            double fontSize = ((GraphicsContextImpl)gc).calculateFontSize(this.label, height, width, 8.0);
            gc.drawTextInBounds(this.label, bounds.x() * scale, bounds.y() * scale, width, height, Align.CENTER, textColor, fontSize);
        }
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
        double scaleX = x / scale;
        double scaleY = y / scale;
        Bounds bounds = this.layout.getBounds();
        if (bounds == null || !bounds.contains(scaleX, scaleY)) {
            return;
        }
        if (this.inputImpl == null) {
            if (this.command == null) {
                return;
            }
            if (mouseEvent == 501) {
                this.command.execute(ButtonEvent.DOWN, 127);
            } else if (mouseEvent == 502) {
                this.command.execute(ButtonEvent.UP, 0);
            }
            return;
        }
        try {
            switch (mouseEvent) {
                case 502: {
                    this.handleMouseUp();
                    break;
                }
                case 501: {
                    this.handleMouseDown(scaleY, bounds);
                    break;
                }
                case 506: {
                    if (this.type != BindType.NOTE || !this.isPressed()) break;
                    this.handleMouseDragged(scaleY, bounds);
                    break;
                }
            }
        }
        catch (InvalidMidiDataException ex) {
            this.host.error("Invalid MIDI message.", ex);
        }
    }

    protected void handleMouseDragged(double scaleY, Bounds bounds) throws InvalidMidiDataException {
        if (this.currentY < 0.0) {
            this.currentY = bounds.y();
        }
        double v = 1.0 - Math.abs(scaleY - this.currentY) / bounds.height();
        this.inputImpl.handleMidiMessage(new ShortMessage(160, this.channel, this.control, (int)Math.max(0L, Math.round(v * 127.0))));
    }

    protected void handleMouseUp() throws InvalidMidiDataException {
        if (this.isPressed() && this.value < 0) {
            int type = this.type == BindType.CC ? 176 : 128;
            this.inputImpl.handleMidiMessage(new ShortMessage(type, this.channel, this.control, 0));
        }
    }

    protected void handleMouseDown(double scaleY, Bounds bounds) throws InvalidMidiDataException {
        double v = 1.0 - Math.abs(scaleY - bounds.y()) / bounds.height();
        int type = this.type == BindType.CC ? 176 : 144;
        int midiValue = this.value < 0 ? (int)Math.max(0L, Math.round(v * 127.0)) : this.value;
        this.inputImpl.handleMidiMessage(new ShortMessage(type, this.channel, this.control, midiValue));
    }
}

