/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.List;

public class DeviceCreatorFilterColumn
extends BaseColumn {
    public DeviceCreatorFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Creator", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceVendorBrowserColumnItem(i);
        }
    }

    @Override
    public List<String> getAllItems() {
        return DeviceManager.get().getVendors();
    }

    private class DeviceVendorBrowserColumnItem
    extends BaseColumnItem {
        public DeviceVendorBrowserColumnItem(int index) {
            super(index);
        }

        @Override
        public int getIndex() {
            return DeviceCreatorFilterColumn.this.calcPosition(this.index);
        }

        @Override
        public boolean isSelected() {
            return this.getIndex() == DeviceCreatorFilterColumn.this.selectedRow;
        }

        @Override
        protected String getCachedName() {
            if (this.position == 0) {
                return "All";
            }
            int pos = this.position - 1;
            return pos < DeviceCreatorFilterColumn.this.getMaxNumItems() ? DeviceManager.get().getVendors().get(pos) : "";
        }

        @Override
        protected int getCachedHitCount() {
            DeviceManager deviceManager = DeviceManager.get();
            if (this.position == 0) {
                return deviceManager.getNumDevices();
            }
            int pos = this.position - 1;
            return pos < DeviceCreatorFilterColumn.this.getMaxNumItems() ? deviceManager.filterByVendor(deviceManager.getVendors().get(pos)).size() : 0;
        }
    }
}

