/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.data.IParameterList;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.DeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.ParameterListImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.DrumPadBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.LayerBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;

public class SpecificDeviceImpl
extends DeviceImpl
implements ISpecificDevice {
    private boolean isWindowOpen;
    private boolean isExpanded;
    private final ParameterBankImpl parameterBank;
    private final ILayerBank layerBank;
    private final IDrumPadBank drumPadBank;
    private final IParameterList parameterList;
    private int lastTouchedParameterIndex;

    public SpecificDeviceImpl(DataSetupEx dataSetup, int numSends, int numParams, int numListParams, int numDevicesInBank, int numDeviceLayers, int numDrumPadLayers) {
        this(dataSetup, Processor.DEVICE, numSends, numParams, numListParams, numDevicesInBank, numDeviceLayers, numDrumPadLayers);
    }

    public SpecificDeviceImpl(DataSetupEx dataSetup, Processor processor, int numSends, int numParams, int numListParams, int numDevicesInBank, int numDeviceLayers, int numDrumPadLayers) {
        super(dataSetup, -1);
        int checkedNumParams = numParams >= 0 ? numParams : 8;
        int checkedNumDeviceLayers = numDeviceLayers >= 0 ? numDeviceLayers : 8;
        int checkedNumDrumPadLayers = numDrumPadLayers >= 0 ? numDrumPadLayers : 16;
        this.parameterBank = checkedNumParams > 0 ? new ParameterBankImpl(dataSetup, processor, checkedNumParams, this) : null;
        this.parameterList = new ParameterListImpl(numListParams / 8, this.parameterBank, this);
        this.layerBank = new LayerBankImpl(dataSetup, checkedNumDeviceLayers);
        this.drumPadBank = new DrumPadBankImpl(dataSetup, checkedNumDrumPadLayers, numSends);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.sender.enableUpdates(Processor.DEVICE, enable);
    }

    @Override
    public String getID() {
        return this.getUnpagedParameterName(0);
    }

    public String getUnpagedParameterName(int index) {
        if (this.parameterBank == null || this.parameterBank.getItemCount() <= index) {
            return "";
        }
        String name = ((ParameterImpl)this.parameterBank.getUnpagedItem(index)).getName();
        return name == null ? "" : name;
    }

    @Override
    public String getName(int limit) {
        String n = this.getName();
        if (n.length() < limit) {
            return n;
        }
        String[] split = n.split(": ");
        if (split.length == 2) {
            n = split[1];
        }
        if (n.length() < limit) {
            return n;
        }
        return n.substring(0, limit);
    }

    @Override
    public boolean isPlugin() {
        return true;
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public boolean isParameterPageSectionVisible() {
        return true;
    }

    @Override
    public boolean isWindowOpen() {
        return this.isWindowOpen;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public boolean hasDrumPads() {
        return true;
    }

    @Override
    public void addHasDrumPadsObserver(IValueObserver<Boolean> observer) {
    }

    @Override
    public void removeHasDrumPadsObserver(IValueObserver<Boolean> observer) {
    }

    @Override
    public boolean hasLayers() {
        return false;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void toggleWindowOpen() {
        this.sender.processBooleanArg(Processor.DEVICE, "window", !this.isWindowOpen);
    }

    @Override
    public void toggleExpanded() {
        this.isExpanded = !this.isExpanded;
        this.sender.processBooleanArg(Processor.DEVICE, "expand", this.isExpanded);
    }

    @Override
    public void toggleParameterPageSectionVisible() {
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public void setWindowOpen(boolean isWindowOpen) {
        this.isWindowOpen = isWindowOpen;
    }

    public void setParameterCount(int count) {
        if (this.parameterBank != null) {
            this.parameterBank.setItemCount(count);
        }
    }

    @Override
    public IParameterBank getParameterBank() {
        return this.parameterBank;
    }

    @Override
    public IParameterList getParameterList() {
        return this.parameterList;
    }

    @Override
    public ILayerBank getLayerBank() {
        return this.layerBank;
    }

    @Override
    public IDrumPadBank getDrumPadBank() {
        return this.drumPadBank;
    }

    public void setLastTouchedParameterIndex(int lastTouchedParameterIndex) {
        this.lastTouchedParameterIndex = lastTouchedParameterIndex;
    }

    public int getLastTouchedParameterIndex() {
        return this.lastTouchedParameterIndex;
    }
}

