/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;

public class SendImpl
extends ParameterImpl
implements ISend {
    private static final Object UPDATE_LOCK = new Object();
    private final IChannel channel;
    private ColorEx color;
    private boolean isEnabled = false;

    public SendImpl(DataSetupEx dataSetup, IChannel channel, int index, double defaultValue) {
        super(dataSetup, index, defaultValue);
        this.channel = channel;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void toggleEnabled() {
        StringBuilder command = new StringBuilder().append(this.channel.getPosition()).append("/send/").append(this.getPosition()).append("/active");
        this.sender.processDoubleArg(Processor.TRACK, command.toString(), this.value);
    }

    @Override
    public void inc(double increment) {
        this.setValue((int)((double)this.getValue() + increment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int value) {
        if (!this.doesExist()) {
            return;
        }
        Object object = UPDATE_LOCK;
        synchronized (object) {
            if (this.isAutomationRecActive()) {
                this.sender.delayUpdates(Processor.TRACK);
            }
            this.value = this.valueChanger.toNormalizedValue(value);
            this.sendValue();
        }
    }

    @Override
    protected void sendValue() {
        StringBuilder command = new StringBuilder().append(this.channel.getPosition()).append("/send/").append(this.getPosition()).append("/volume");
        this.sender.processDoubleArg(Processor.TRACK, command.toString(), this.value);
    }

    @Override
    public ColorEx getColor() {
        return this.color;
    }

    public void setColorState(double[] color) {
        this.color = new ColorEx(color);
    }

    public void setInternalEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}

