/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.observer.IObserverManagement;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;

public abstract class BaseImpl
implements IObserverManagement {
    protected final DataSetupEx dataSetup;
    protected final IHost host;
    protected final MessageSender sender;
    protected final IValueChanger valueChanger;

    protected BaseImpl(DataSetupEx dataSetup) {
        this.dataSetup = dataSetup;
        this.host = dataSetup != null ? dataSetup.getHost() : null;
        this.sender = dataSetup != null ? dataSetup.getSender() : null;
        this.valueChanger = dataSetup != null ? dataSetup.getValueChanger() : null;
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    public boolean isAutomationRecActive() {
        ITransport transport = this.dataSetup.getTransport();
        return transport != null && transport.isWritingArrangerAutomation();
    }

    public void invokeAction(int id) {
        this.sender.invokeAction(id);
    }

    protected void sendOSC(String command) {
        this.sender.processNoArg(this.getProcessor(), command);
    }

    protected void sendOSC(String command, int value) {
        this.sender.processIntArg(this.getProcessor(), command, value);
    }

    protected void sendOSC(String command, double value) {
        this.sender.processDoubleArg(this.getProcessor(), command, value);
    }

    protected void sendOSC(String command, boolean value) {
        this.sender.processBooleanArg(this.getProcessor(), command, value);
    }

    protected void sendOSC(String command, String value) {
        this.sender.processStringArg(this.getProcessor(), command, value);
    }

    protected abstract Processor getProcessor();
}

