/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IActionSetting;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.configuration.BaseValueSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import de.mossgrabers.reaper.ui.widget.ActionPanel;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class ActionSettingImpl
extends BaseValueSetting<ActionPanel, String>
implements IActionSetting {
    private String value;
    private boolean isSelectionActive;

    public ActionSettingImpl(MessageSender sender, LogModel logModel, PropertiesEx properties, String label, String category) {
        super(logModel, label, category, new ActionPanel());
        this.load(properties);
        ((ActionPanel)this.field).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SafeRunLater.execute(ActionSettingImpl.this.logModel, () -> ActionSettingImpl.this.set(((ActionPanel)ActionSettingImpl.this.field).getTextField().getText()));
            }
        });
        ((ActionPanel)this.field).getSelectButton().addActionListener(e -> {
            sender.processNoArg(Processor.ACTION, "select");
            this.isSelectionActive = true;
        });
    }

    public boolean isSelectionActive() {
        return this.isSelectionActive;
    }

    @Override
    public void set(String value) {
        this.value = value;
        this.setDirty();
        this.flush();
        this.isSelectionActive = false;
        SafeRunLater.execute(this.logModel, () -> {
            JTextField textField = ((ActionPanel)this.field).getTextField();
            String v = textField.getText();
            if (v == null || !v.equals(this.value)) {
                textField.setText(this.value);
            }
        });
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value == null ? "" : this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), this.value);
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getString(this.getID(), ""));
    }

    @Override
    public void reset() {
        this.set("");
    }
}

