/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.framework.IniFiles;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.ModelImpl;
import de.mossgrabers.reaper.framework.midi.MidiAccessImpl;
import de.mossgrabers.reaper.framework.midi.NoteRepeatImpl;
import java.util.List;

public class ReaperSetupFactory
implements ISetupFactory {
    private final MessageSender sender;
    private final IHost host;
    private final MidiAccessImpl midiAccess;
    private final IniFiles iniFiles;

    public ReaperSetupFactory(IniFiles iniFiles, MessageSender sender, IHost host, MidiAccessImpl midiAccess) {
        this.iniFiles = iniFiles;
        this.sender = sender;
        this.host = host;
        this.midiAccess = midiAccess;
    }

    public void cleanup() {
        this.midiAccess.cleanup();
    }

    @Override
    public IModel createModel(Configuration configuration, ColorManager colorManager, IValueChanger valueChanger, Scales scales, ModelSetup modelSetup) {
        DataSetupEx dataSetup = new DataSetupEx(this.host, valueChanger, colorManager, this.sender);
        return new ModelImpl(configuration, modelSetup, dataSetup, scales, this.iniFiles);
    }

    @Override
    public IMidiAccess createMidiAccess() {
        return this.midiAccess;
    }

    @Override
    public List<ArpeggiatorMode> getArpeggiatorModes() {
        return NoteRepeatImpl.ARP_MODES;
    }
}

