/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.controller;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.framework.controller.IControllerSetup;
import de.mossgrabers.framework.usb.UsbMatcher;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.TestCallback;
import de.mossgrabers.reaper.communication.MessageParser;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.framework.Actions;
import de.mossgrabers.reaper.framework.IniFiles;
import de.mossgrabers.reaper.framework.ReaperSetupFactory;
import de.mossgrabers.reaper.framework.configuration.DocumentSettingsUI;
import de.mossgrabers.reaper.framework.configuration.GlobalSettingsUI;
import de.mossgrabers.reaper.framework.daw.HostImpl;
import de.mossgrabers.reaper.framework.midi.MidiAccessImpl;
import de.mossgrabers.reaper.framework.midi.MissingMidiDevice;
import de.mossgrabers.reaper.ui.SimulatorWindow;
import de.mossgrabers.reaper.ui.WindowManager;
import de.mossgrabers.reaper.ui.dialog.ConfigurationDialog;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.swing.JFrame;

public abstract class AbstractControllerInstance<S extends IControlSurface<C>, C extends Configuration>
implements IControllerInstance,
TestCallback {
    protected final IControllerDefinition controllerDefinition;
    protected final LogModel logModel;
    protected final WindowManager windowManager;
    protected final MessageSender sender;
    protected final IniFiles iniFiles;
    protected HostImpl host;
    protected GlobalSettingsUI globalSettingsUI;
    protected final DocumentSettingsUI documentSettingsUI;
    protected ReaperSetupFactory setupFactory;
    protected IControllerSetup<?, ?> controllerSetup;
    protected PropertiesEx controllerConfiguration = new PropertiesEx();
    protected MessageParser oscParser;
    private boolean isRunning = false;
    private final Object startSync = new Object();
    private final List<JFrame> simulators = new ArrayList<JFrame>();
    private ConfigurationDialog configurationDialog;

    protected AbstractControllerInstance(IControllerDefinition controllerDefinition, LogModel logModel, WindowManager windowManager, MessageSender sender, IniFiles iniFiles) {
        this.controllerDefinition = controllerDefinition;
        this.logModel = logModel;
        this.windowManager = windowManager;
        this.sender = sender;
        this.iniFiles = iniFiles;
        this.documentSettingsUI = new DocumentSettingsUI(this.logModel);
    }

    @Override
    public IControllerDefinition getDefinition() {
        return this.controllerDefinition;
    }

    @Override
    public IControllerSetup<?, ?> getControllerSetup() {
        return this.controllerSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.startSync;
        synchronized (object) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.isRunning) {
                return;
            }
            this.host = new HostImpl(this.logModel, this.windowManager, this);
            this.loadConfiguration();
            this.documentSettingsUI.clearWidgets();
            this.globalSettingsUI = new GlobalSettingsUI(this.sender, this.logModel, this.controllerConfiguration, this.controllerDefinition.getNumMidiInPorts(), this.controllerDefinition.getNumMidiOutPorts(), this.controllerDefinition.getMidiDiscoveryPairs(OperatingSystem.get()));
            this.globalSettingsUI.initMIDI();
            if (!this.checkMidiDevices()) {
                return;
            }
            if (!this.isEnabled()) {
                this.logModel.info(this.controllerDefinition.toString() + ": Deactivated.");
                return;
            }
            this.logModel.info(this.controllerDefinition.toString() + ": Starting...");
            UsbMatcher matcher = this.controllerDefinition.claimUSBDevice();
            if (matcher != null) {
                this.host.addUSBDeviceInfo(matcher);
            }
            MidiAccessImpl midiAccess = new MidiAccessImpl(this.logModel, this.host, this.sender, this.globalSettingsUI.getSelectedMidiInputs(), this.globalSettingsUI.getSelectedMidiOutputs());
            this.setupFactory = new ReaperSetupFactory(this.iniFiles, this.sender, this.host, midiAccess);
            this.controllerSetup = this.createControllerSetup(this.setupFactory);
            SafeRunLater.execute(this.logModel, this::delayedStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        Object object = this.startSync;
        synchronized (object) {
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.startSync;
        synchronized (object) {
            if (!this.isRunning) {
                return;
            }
            if (this.globalSettingsUI.isDirty()) {
                this.logModel.info("Storing configuration...");
                this.storeConfiguration();
            }
            this.logModel.info("Closing controller...");
            if (this.controllerSetup != null) {
                this.controllerSetup.exit();
            }
            if (this.host != null) {
                this.host.shutdown();
                this.logModel.info("Release resources...");
                this.host.releaseUsbDevices();
                this.host.releaseOSC();
            }
            this.logModel.info("Closing MIDI connections...");
            if (this.setupFactory != null) {
                this.setupFactory.cleanup();
            }
            this.isRunning = false;
        }
    }

    @Override
    public GlobalSettingsUI getGlobalSettingsUI() {
        return this.globalSettingsUI;
    }

    @Override
    public DocumentSettingsUI getDocumentSettingsUI() {
        return this.documentSettingsUI;
    }

    protected abstract IControllerSetup<S, C> createControllerSetup(ReaperSetupFactory var1);

    public HostImpl getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.startSync;
        synchronized (object) {
            if (!this.isEnabled() || !this.isRunning) {
                return;
            }
            if (this.controllerSetup != null) {
                this.controllerSetup.flush();
            }
            this.simulators.forEach(Component::repaint);
        }
    }

    @Override
    public void parse(String address, String argument) {
        if (this.oscParser == null) {
            return;
        }
        if ("/action/select".equals(address)) {
            if (this.configurationDialog != null) {
                this.configurationDialog.setAction(argument);
            }
        } else {
            this.oscParser.parseOSC(address, argument);
        }
    }

    @Override
    public void edit() {
        this.configurationDialog = new ConfigurationDialog(this.logModel, this.windowManager.getMainFrame(), this.globalSettingsUI);
        this.configurationDialog.showDialog();
        this.configurationDialog = null;
        this.storeConfiguration();
    }

    @Override
    public boolean isEnabled() {
        return this.globalSettingsUI != null && this.globalSettingsUI.isEnabled();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.globalSettingsUI.setEnabled(isEnabled);
    }

    @Override
    public synchronized void simulateUI() {
        if (this.controllerSetup == null) {
            return;
        }
        if (this.simulators.isEmpty()) {
            this.controllerSetup.getSurfaces().forEach(surface -> this.simulators.add(new SimulatorWindow((IControlSurface<?>)surface, this.toString(), true)));
        }
        this.simulators.forEach(simulator -> simulator.setVisible(true));
    }

    @Override
    public synchronized void testUI() {
        if (this.controllerSetup == null) {
            return;
        }
        this.controllerSetup.test(this);
    }

    @Override
    public void startTesting() {
        this.logModel.info("Enable testing.");
        Actions.setTesting(true);
    }

    @Override
    public void endTesting() {
        this.logModel.info("Testing finished.");
        Actions.setTesting(false);
    }

    public String toString() {
        return this.controllerDefinition.toString();
    }

    private File getFileName() {
        return new File(this.iniFiles.getIniPath(), "DrivenByMoss4Reaper-" + this.controllerDefinition.getHardwareModel().replace(' ', '-').replace('/', '-') + ".config");
    }

    private void delayedStart() {
        this.controllerSetup.init();
        this.globalSettingsUI.init();
        this.oscParser = new MessageParser(this.controllerSetup);
        this.globalSettingsUI.flush();
        this.host.scheduleTask(() -> {
            try {
                this.controllerSetup.startup();
            }
            catch (RuntimeException ex) {
                this.logModel.error(this.controllerDefinition.toString() + ": Could not start controller.", ex);
            }
        }, 1000L);
        this.isRunning = true;
        this.logModel.info(this.controllerDefinition.toString() + ": Running.");
    }

    private void loadConfiguration() {
        File configFile = this.getFileName();
        if (!configFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            this.controllerConfiguration.load(reader);
        }
        catch (IOException ex) {
            this.logModel.error("Could not load controller configuration file.", ex);
        }
    }

    @Override
    public void storeConfiguration() {
        try (FileWriter writer = new FileWriter(this.getFileName());){
            this.globalSettingsUI.store(this.controllerConfiguration);
            this.controllerConfiguration.store(writer, "");
        }
        catch (IOException ex) {
            this.logModel.error("Could not save controller configuration file.", ex);
        }
    }

    private boolean checkMidiDevices() {
        MissingMidiDevice missing;
        boolean result = true;
        for (MidiDevice midiInput : this.globalSettingsUI.getSelectedMidiInputs()) {
            if (!(midiInput instanceof MissingMidiDevice)) continue;
            missing = (MissingMidiDevice)midiInput;
            if (missing == MissingMidiDevice.NONE) {
                this.logModel.info(this.controllerDefinition.toString() + ": MIDI input device not configured.");
            } else {
                this.logModel.info(this.controllerDefinition.toString() + ": " + missing.getDeviceInfo().getName());
            }
            result = false;
        }
        for (MidiDevice midiOutput : this.globalSettingsUI.getSelectedMidiOutputs()) {
            if (!(midiOutput instanceof MissingMidiDevice)) continue;
            missing = (MissingMidiDevice)midiOutput;
            if (missing == MissingMidiDevice.NONE) {
                this.logModel.info(this.controllerDefinition.toString() + ": MIDI output device not configured.");
            } else {
                this.logModel.info(this.controllerDefinition.toString() + ": " + missing.getDeviceInfo().getName());
            }
            result = false;
        }
        return result;
    }
}

