/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;

public class AutomationModeParameter
extends AbstractParameterImpl {
    protected final ITransport transport;

    public AutomationModeParameter(IValueChanger valueChanger, ITransport transport) {
        super(valueChanger, 0);
        this.transport = transport;
    }

    @Override
    public int getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNormalizedValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        this.inc(valueChanger.isIncrease(value) ? 1.0 : -1.0);
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(value);
    }

    @Override
    public void inc(double increment) {
        if (increment > 0.0) {
            this.transport.nextAutomationWriteMode(false);
        } else {
            this.transport.previousAutomationWriteMode();
        }
    }

    @Override
    public void resetValue() {
        this.transport.setAutomationWriteMode(AutomationMode.READ);
    }

    @Override
    public String getDisplayedValue() {
        return this.transport.getAutomationWriteMode().getLabel();
    }

    @Override
    public boolean doesExist() {
        return true;
    }

    @Override
    public String getName() {
        return "Automation Mode";
    }

    @Override
    public int getNumberOfSteps() {
        return this.transport.getAutomationWriteModes().length;
    }
}

