/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.track;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.FrameworkException;
import java.util.List;

public class MasterAndFXVolumeMode<S extends IControlSurface<C>, C extends Configuration>
extends DefaultTrackMode<S, C> {
    public MasterAndFXVolumeMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        super("FX and master volumes", surface, model, isAbsolute, controls);
        int numnFXTracks = controls.size() - 2;
        if (numnFXTracks < 0) {
            throw new FrameworkException("Number of controls must be at least 2.");
        }
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        this.setParameterProvider(new CombinedParameterProvider(effectTrackBank == null ? new EmptyParameterProvider(numnFXTracks) : new RangeFilterParameterProvider(new VolumeParameterProvider(effectTrackBank), 0, numnFXTracks), new FixedParameterProvider(this.model.getTransport().getMetronomeVolumeParameter()), new FixedParameterProvider(this.model.getMasterTrack().getVolumeParameter())));
    }
}

